/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ISpecialBlockPickItem;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.client.TagSubstitutionRenderer;
import com.ldtteam.structurize.items.ItemStackTooltip;
import com.ldtteam.structurize.network.messages.AbsorbBlockMessage;
import com.ldtteam.structurize.tag.ModTags;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

public class ItemTagSubstitution
extends BlockItem
implements ISpecialBlockPickItem {
    public ItemTagSubstitution(@NotNull Item.Properties properties) {
        super((Block)ModBlocks.blockTagSubstitution.get(), properties);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return TagSubstitutionRenderer.getInstance();
            }
        });
    }

    @Override
    @NotNull
    public InteractionResult onBlockPick(@NotNull Player player, @NotNull ItemStack stack, @Nullable BlockPos pos, boolean ctrlKey) {
        if (pos == null) {
            if (!player.m_9236_().m_5776_()) {
                this.clearAbsorbedBlock(stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = player.m_9236_().m_8055_(pos);
        if (blockstate.m_204336_(BlockTags.f_13070_)) {
            if (!player.m_9236_().m_5776_()) {
                this.clearAbsorbedBlock(stack);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_9236_().m_5776_()) {
            ItemStack pick = this.getPickedBlock(player, pos, blockstate);
            Network.getNetwork().sendToServer(new AbsorbBlockMessage(pos, pick));
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    private ItemStack getPickedBlock(@NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState blockstate) {
        return blockstate.getCloneItemStack(Minecraft.m_91087_().f_91077_, (BlockGetter)player.m_9236_(), pos, player);
    }

    private void clearAbsorbedBlock(@NotNull ItemStack stack) {
        ItemTagSubstitution.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.TAG_SUBSTITUTION.get()), (CompoundTag)new CompoundTag());
    }

    public void onAbsorbBlock(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BlockPos pos, @NotNull ItemStack absorbItem) {
        BlockEntityTagSubstitution.ReplacementBlock replacement;
        BlockState blockstate = player.m_9236_().m_8055_(pos);
        BlockEntity blockentity = player.m_9236_().m_7702_(pos);
        if (blockentity instanceof BlockEntityTagSubstitution) {
            BlockEntityTagSubstitution blockception = (BlockEntityTagSubstitution)blockentity;
            replacement = blockception.getReplacement();
        } else {
            if (!this.isAllowed(blockentity)) {
                Utils.playErrorSound((Player)player);
                return;
            }
            replacement = new BlockEntityTagSubstitution.ReplacementBlock(blockstate, blockentity, absorbItem);
        }
        ItemTagSubstitution.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.TAG_SUBSTITUTION.get()), (CompoundTag)replacement.write(new CompoundTag()));
    }

    private boolean isAllowed(@Nullable BlockEntity blockentity) {
        if (blockentity == null) {
            return true;
        }
        ITag tag = ForgeRegistries.BLOCK_ENTITY_TYPES.tags().getTag(ModTags.SUBSTITUTION_ABSORB_WHITELIST);
        return tag.contains((Object)blockentity.m_58903_());
    }

    @NotNull
    public BlockEntityTagSubstitution.ReplacementBlock getAbsorbedBlock(@NotNull ItemStack stack) {
        CompoundTag tag = Objects.requireNonNullElse(ItemTagSubstitution.m_186336_((ItemStack)stack), new CompoundTag());
        return new BlockEntityTagSubstitution.ReplacementBlock(tag);
    }

    public Component getHighlightTip(@NotNull ItemStack stack, @NotNull Component displayName) {
        BlockEntityTagSubstitution.ReplacementBlock absorbed = this.getAbsorbedBlock(stack);
        if (!absorbed.isEmpty()) {
            return Component.m_237119_().m_7220_(super.getHighlightTip(stack, displayName)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_(absorbed.getItemStack().m_41786_());
        }
        return super.getHighlightTip(stack, displayName);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        BlockEntityTagSubstitution.ReplacementBlock absorbed = this.getAbsorbedBlock(stack);
        ItemStack absorbedItem = absorbed.getItemStack();
        if (!absorbedItem.m_41619_()) {
            return Optional.of(new ItemStackTooltip(absorbedItem));
        }
        return super.m_142422_(stack);
    }

    @Nullable
    protected BlockState m_5965_(@NotNull BlockPlaceContext context) {
        return super.m_5965_(context);
    }
}

