/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.IScrollableItem;
import com.ldtteam.structurize.api.util.ISpecialBlockPickItem;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.commands.ScanCommand;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ShowScanMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScanTool
extends AbstractItemWithPosSelector
implements IScrollableItem,
ISpecialBlockPickItem {
    private static final String ANCHOR_POS_TKEY = "item.possetter.anchorpos";
    private static final String NBT_ANCHOR_POS = "structurize:anchor_pos";
    private static final String NBT_NAME = "structurize:name";
    private static final String NBT_COMMAND_POS = "structurize:cmd_pos";
    private static final String NBT_DIMENSION = "structurize:dim";

    public ItemScanTool(CreativeModeTab itemGroup) {
        this(new Item.Properties().m_41503_(0).setNoRepair().m_41497_(Rarity.UNCOMMON).m_41491_(itemGroup));
    }

    public ItemScanTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        ScanToolData data = new ScanToolData(itemStack.m_41784_());
        this.saveSlot(data, itemStack, playerIn);
        if (!worldIn.f_46443_) {
            if (playerIn.m_6144_()) {
                ItemScanTool.saveStructure(worldIn, playerIn, data.getCurrentSlotData(), true);
            }
        } else if (!playerIn.m_6144_()) {
            WindowScan window = new WindowScan(data);
            window.open();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)((Object)ModItems.scanTool.get());
    }

    public static void saveStructure(Level world, Player player, ScanToolData.Slot slot, boolean saveEntities) {
        List list;
        if (slot.getBox().getAnchor().isPresent() && !BlockPosUtil.isInbetween(slot.getBox().getAnchor().get(), slot.getBox().getPos1(), slot.getBox().getPos2())) {
            player.m_5661_((Component)Component.m_237115_((String)"item.sceptersteel.badanchorpos"), false);
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)slot.getBox().getPos1(), (Vec3i)slot.getBox().getPos2());
        if (box.m_71056_() * box.m_71057_() * box.m_71058_() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            player.m_5661_((Component)Component.m_237110_((String)"item.sceptersteel.toobig", (Object[])new Object[]{Structurize.getConfig().getServer().schematicBlockLimit.get()}), false);
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        Object fileName = slot.getName().isEmpty() ? Component.m_237110_((String)"item.sceptersteel.scanformat", (Object[])new Object[]{"", currentMillisString}).getString() : slot.getName();
        if (!((String)fileName).contains(".blueprint")) {
            fileName = (String)fileName + ".blueprint";
        }
        BlockPos zero = new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_());
        Blueprint bp = BlueprintUtil.createBlueprint(world, zero, saveEntities, (short)box.m_71056_(), (short)box.m_71057_(), (short)box.m_71058_(), (String)fileName, slot.getBox().getAnchor());
        if (slot.getBox().getAnchor().isEmpty() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().m_128441_("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.m_5661_((Component)Component.m_237110_((String)"com.ldtteam.structurize.gui.scantool.scanbadanchor", (Object[])new Object[]{fileName}), false);
        }
        Network.getNetwork().sendToPlayer(new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), (String)fileName), (ServerPlayer)player);
    }

    @Override
    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        BlockEntity te;
        ItemStack itemstack;
        if (!player.m_6144_()) {
            return super.m_6777_(state, worldIn, pos, player);
        }
        if (worldIn.m_5776_()) {
            player.m_5661_((Component)Component.m_237110_((String)ANCHOR_POS_TKEY, (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
        }
        if (!(itemstack = player.m_21205_()).m_41720_().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.m_21206_();
        }
        if ((te = worldIn.m_7702_(pos)) instanceof IBlueprintDataProviderBE && !((IBlueprintDataProviderBE)te).getSchematicName().isEmpty()) {
            if (worldIn.f_46443_ && RenderingCache.getBoxPreviewData("scan") != null) {
                RenderingCache.getBoxPreviewData("scan").setAnchor(Optional.of(pos));
            }
            BlockPos start = (BlockPos)((IBlueprintDataProviderBE)te).getInWorldCorners().m_14418_();
            BlockPos end = (BlockPos)((IBlueprintDataProviderBE)te).getInWorldCorners().m_14419_();
            if (!start.equals((Object)pos) && !end.equals((Object)pos)) {
                if (worldIn.f_46443_) {
                    RenderingCache.queue("scan", new BoxPreviewData((BlockPos)((IBlueprintDataProviderBE)te).getInWorldCorners().m_14418_(), (BlockPos)((IBlueprintDataProviderBE)te).getInWorldCorners().m_14419_(), Optional.of(pos)));
                }
                ItemScanTool.setBounds(itemstack, start, end);
            }
        }
        ItemScanTool.setAnchorPos(itemstack, pos);
        return false;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (stack.m_41782_()) {
            tooltip.add(this.getCurrentSlotDescription(stack));
        }
    }

    public Component getHighlightTip(@NotNull ItemStack stack, @NotNull Component displayName) {
        return Component.m_237119_().m_7220_(super.getHighlightTip(stack, displayName)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_(this.getCurrentSlotDescription(stack));
    }

    private Component getCurrentSlotDescription(@NotNull ItemStack stack) {
        ScanToolData data = new ScanToolData(stack.m_41784_());
        MutableComponent desc = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)String.valueOf(data.getCurrentSlotId())).m_130940_(ChatFormatting.GRAY));
        String name = ItemScanTool.getStructureName(stack);
        if (!name.isEmpty()) {
            desc = desc.m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)name));
        }
        return desc;
    }

    @Override
    @NotNull
    public InteractionResult onBlockPick(@NotNull Player player, @NotNull ItemStack stack, @Nullable BlockPos pos, boolean ctrlKey) {
        if (pos == null) {
            double delta = player.m_6144_() ? -1.0 : 1.0;
            return this.onMouseScroll(player, stack, delta, ctrlKey);
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity command = (CommandBlockEntity)blockEntity;
            return this.onCommandBlockPick(player, stack, command, ctrlKey);
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResult onMouseScroll(@NotNull Player player, @NotNull ItemStack stack, double delta, boolean ctrlKey) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        this.switchSlot((ServerPlayer)player, stack, delta < 0.0 ? ScanToolData::prevSlot : ScanToolData::nextSlot);
        return InteractionResult.SUCCESS;
    }

    private void switchSlot(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Consumer<ScanToolData> action) {
        ScanToolData data = new ScanToolData(stack.m_41784_());
        this.saveSlot(data, stack, (Player)player);
        action.accept(data);
        ScanToolData.Slot slot = this.loadSlot(data, stack);
        Network.getNetwork().sendToPlayer(new ShowScanMessage(slot.getBox()), player);
    }

    private void saveSlot(@NotNull ScanToolData data, @NotNull ItemStack stack, @NotNull Player player) {
        data.setCurrentSlotData(new ScanToolData.Slot(ItemScanTool.getStructureName(stack), ItemScanTool.getBox(stack, player)));
    }

    public ScanToolData.Slot loadSlot(@NotNull ScanToolData data, @NotNull ItemStack stack) {
        ScanToolData.Slot slot = data.getCurrentSlotData();
        ItemScanTool.setStructureName(stack, slot.getName());
        ItemScanTool.setBounds(stack, slot.getBox().getPos1(), slot.getBox().getPos2());
        ItemScanTool.setAnchorPos(stack, slot.getBox().getAnchor().orElse(null));
        return slot;
    }

    private InteractionResult onCommandBlockPick(@NotNull Player player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        if (!player.m_7500_()) {
            return InteractionResult.PASS;
        }
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            this.onCommandBlockPaste((ServerPlayer)player, stack, command, ctrlKey);
        } else {
            this.onCommandBlockCopy((ServerPlayer)player, stack, command, ctrlKey);
        }
        return InteractionResult.SUCCESS;
    }

    private void onCommandBlockCopy(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        CommandDispatcher dispatcher;
        ParseResults parsed;
        StringReader reader = new StringReader(command.m_59141_().m_45438_());
        if (reader.canRead() && reader.peek() == '/') {
            reader.read();
        }
        if ((parsed = (dispatcher = player.m_9236_().m_7654_().m_129892_().m_82094_()).parse(reader, (Object)command.m_59141_().m_6712_())).getReader().canRead() || parsed.getContext().getNodes().size() < 4 || !((ParsedCommandNode)parsed.getContext().getNodes().get(0)).getNode().getName().equals("structurize") || !((ParsedCommandNode)parsed.getContext().getNodes().get(1)).getNode().getName().equals("scan")) {
            player.m_213846_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.copy.notscan"));
            return;
        }
        CommandContext cmdContext = parsed.getContext().build(parsed.getReader().getString());
        try {
            BlockPos from = BlockPosArgument.m_174395_((CommandContext)cmdContext, (String)"pos1");
            BlockPos to = BlockPosArgument.m_174395_((CommandContext)cmdContext, (String)"pos2");
            Optional<BlockPos> anchor = Optional.empty();
            if (parsed.getContext().getArguments().containsKey("anchor_pos")) {
                anchor = Optional.of(BlockPosArgument.m_174395_((CommandContext)cmdContext, (String)"anchor_pos"));
            }
            String name = "";
            if (parsed.getContext().getArguments().containsKey("filename")) {
                name = StringArgumentType.getString((CommandContext)cmdContext, (String)"filename");
            }
            stack.m_41784_().m_128365_(NBT_COMMAND_POS, (Tag)NbtUtils.m_129224_((BlockPos)command.m_58899_()));
            stack.m_41784_().m_128359_(NBT_DIMENSION, command.m_58904_().m_46472_().m_135782_().toString());
            ScanToolData data = new ScanToolData(stack.m_41784_());
            data.setCurrentSlotData(new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchor)));
            ScanToolData.Slot slot = this.loadSlot(data, stack);
            Network.getNetwork().sendToPlayer(new ShowScanMessage(slot.getBox()), player);
            player.m_5661_((Component)Component.m_237110_((String)"com.ldtteam.structurize.gui.scantool.copy.ok", (Object[])new Object[]{name}), false);
            player.m_6330_(SoundEvents.f_12211_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        catch (CommandSyntaxException e) {
            player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.copy.notscan"), false);
        }
    }

    private void onCommandBlockPaste(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        ScanToolData data = new ScanToolData(stack.m_41784_());
        this.saveSlot(data, stack, (Player)player);
        ScanToolData.Slot slot = data.getCurrentSlotData();
        if (slot.getName().isBlank() || slot.getName().contains(" ")) {
            player.m_213846_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.paste.badname"));
            player.m_6330_(SoundEvents.f_12170_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (!command.m_59141_().m_45438_().isBlank()) {
            if (!command.m_59141_().m_45438_().contains("structurize scan ")) {
                player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.paste.badcommand"), false);
                player.m_6330_(SoundEvents.f_12170_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return;
            }
            if (!ctrlKey) {
                CommandContext cmdContext;
                String currentName;
                CommandDispatcher dispatcher;
                ParseResults parsed;
                StringReader reader = new StringReader(command.m_59141_().m_45438_());
                if (reader.canRead() && reader.peek() == '/') {
                    reader.read();
                }
                if ((parsed = (dispatcher = player.m_20194_().m_129892_().m_82094_()).parse(reader, (Object)command.m_59141_().m_6712_())).getContext().getArguments().containsKey("filename") && !(currentName = StringArgumentType.getString((CommandContext)(cmdContext = parsed.getContext().build(parsed.getReader().getString())), (String)"filename")).equals(slot.getName())) {
                    player.m_5661_((Component)Component.m_237110_((String)"com.ldtteam.structurize.gui.scantool.paste.different", (Object[])new Object[]{slot.getName(), currentName}), false);
                    player.m_6330_(SoundEvents.f_12218_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
            }
        }
        String cmd = ScanCommand.format(slot);
        command.m_59141_().m_6590_(cmd);
        stack.m_41784_().m_128365_(NBT_COMMAND_POS, (Tag)NbtUtils.m_129224_((BlockPos)command.m_58899_()));
        stack.m_41784_().m_128359_(NBT_DIMENSION, command.m_58904_().m_46472_().m_135782_().toString());
        player.m_5661_((Component)Component.m_237110_((String)"com.ldtteam.structurize.gui.scantool.paste.ok", (Object[])new Object[]{slot.getName()}), false);
        player.m_6330_(SoundEvents.f_12211_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean onTeleport(@NotNull Player player, @NotNull ItemStack stack) {
        BlockPos safeTarget;
        long buildDistance;
        BlockPos target;
        if (!player.m_7500_() || !((Boolean)Structurize.getConfig().getServer().teleportAllowed.get()).booleanValue()) {
            return false;
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_(NBT_COMMAND_POS)) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.teleport.nocmd"), false);
                player.m_5496_(SoundEvents.f_12170_, 1.0f, 1.0f);
            }
            return false;
        }
        if (!player.m_9236_().m_46472_().m_135782_().toString().equals(stack.m_41783_().m_128461_(NBT_DIMENSION))) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.teleport.dimension"), false);
                player.m_5496_(SoundEvents.f_12170_, 1.0f, 1.0f);
            }
            return false;
        }
        ScanToolData data = new ScanToolData(stack.m_41783_());
        ScanToolData.Slot slot = data.getCurrentSlotData();
        if (slot.getBox().getPos1().equals((Object)BlockPos.f_121853_) && slot.getBox().getPos2().equals((Object)BlockPos.f_121853_)) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.teleport.noscan"), false);
                player.m_5496_(SoundEvents.f_12170_, 1.0f, 1.0f);
            }
            return false;
        }
        BlockPos commandPos = NbtUtils.m_129239_((CompoundTag)stack.m_41784_().m_128469_(NBT_COMMAND_POS)).m_7494_();
        BlockPos buildPos = this.getTeleportPos(slot.getBox());
        Level level = player.m_9236_();
        long commandDistance = BlockPosUtil.getDistanceSquared(commandPos, player.m_20183_());
        BlockPos blockPos = target = commandDistance < (buildDistance = BlockPosUtil.getDistanceSquared(buildPos, player.m_20183_())) ? buildPos : commandPos;
        if (((Boolean)Structurize.getConfig().getServer().teleportSafety.get()).booleanValue()) {
            ChunkAccess chunk = level.m_46865_(target);
            safeTarget = BlockPosUtil.findSafeTeleportPos(level, target, false);
            if (safeTarget == null) {
                Log.getLogger().warn("No safe landing for scan-teleport " + player.m_7755_().getString() + " to " + target.m_123344_());
                return false;
            }
            target = safeTarget;
        }
        if (target.m_123342_() < level.m_141937_() + 2) {
            Log.getLogger().warn("Aborting attempt to scan-teleport " + player.m_7755_().getString() + " to " + target.m_123344_());
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)player.m_20183_().m_123341_(), (double)player.m_20183_().m_123342_() + level.m_213780_().m_188500_() * 2.0, (double)player.m_20183_().m_123343_(), level.m_213780_().m_188583_(), 0.0, level.m_213780_().m_188583_());
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)target.m_123341_(), (double)target.m_123342_() + level.m_213780_().m_188500_() * 2.0, (double)target.m_123343_(), level.m_213780_().m_188583_(), 0.0, level.m_213780_().m_188583_());
        }
        safeTarget = player.m_9236_();
        if (safeTarget instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)safeTarget;
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            CommandSourceStack source = new CommandSourceStack(CommandSource.f_80164_, player.m_20182_(), Vec2.f_82462_, serverLevel, 2, player.m_7755_().getString(), stack.m_41611_(), serverLevel.m_7654_(), (Entity)player);
            CommandDispatcher dispatcher = serverLevel.m_7654_().m_129892_().m_82094_();
            try {
                dispatcher.execute(String.format("teleport %s %f %f %f", player.m_20148_(), (double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.0, (double)target.m_123343_() + 0.5), (Object)source);
            }
            catch (Exception e) {
                Log.getLogger().error("Command tool teleport failed", (Throwable)e);
            }
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    @NotNull
    private BlockPos getTeleportPos(@NotNull BoxPreviewData box) {
        Direction direction = (Direction)Structurize.getConfig().getServer().teleportBuildDirection.get();
        int offset = (Integer)Structurize.getConfig().getServer().teleportBuildDistance.get();
        AABB bounds = new AABB(box.getPos1(), box.getPos2());
        int size = (int)Math.round(bounds.m_82374_(direction.m_122434_()) - bounds.m_82340_(direction.m_122434_()));
        return new BlockPos(bounds.m_82399_()).m_175288_((int)bounds.f_82289_).m_5484_(direction, offset + size / 2);
    }

    public static BoxPreviewData getBox(@NotNull ItemStack tool, @NotNull Player player) {
        Tuple<BlockPos, BlockPos> bounds = ItemScanTool.getBounds(tool);
        Optional<Object> anchor = Optional.ofNullable(ItemScanTool.getAnchorPos(tool));
        if (anchor.isPresent() && !BlockPosUtil.isInbetween(anchor.get(), (BlockPos)bounds.m_14418_(), (BlockPos)bounds.m_14419_())) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.outsideanchor"), false);
            }
            anchor = Optional.empty();
        }
        return new BoxPreviewData((BlockPos)bounds.m_14418_(), (BlockPos)bounds.m_14419_(), anchor);
    }

    public static void setAnchorPos(@NotNull ItemStack tool, @Nullable BlockPos anchor) {
        if (anchor == null) {
            tool.m_41784_().m_128473_(NBT_ANCHOR_POS);
        } else {
            tool.m_41784_().m_128365_(NBT_ANCHOR_POS, (Tag)NbtUtils.m_129224_((BlockPos)anchor));
        }
    }

    @Nullable
    public static BlockPos getAnchorPos(@NotNull ItemStack tool) {
        CompoundTag tag = tool.m_41784_();
        return tag.m_128441_(NBT_ANCHOR_POS) ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_(NBT_ANCHOR_POS)) : null;
    }

    public static void setStructureName(@NotNull ItemStack tool, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            tool.m_41784_().m_128473_(NBT_NAME);
        } else {
            tool.m_41784_().m_128359_(NBT_NAME, name);
        }
    }

    public static String getStructureName(@NotNull ItemStack tool) {
        return tool.m_41784_().m_128461_(NBT_NAME);
    }
}

