/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.model;

import com.ldtteam.structurize.client.model.OverlaidBakedModel;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OverlaidGeometry
implements IUnbakedGeometry<OverlaidGeometry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ResourceLocation overlayModelId;
    private UnbakedModel overlayModel;

    public OverlaidGeometry(ResourceLocation overlayModelId) {
        this.overlayModelId = overlayModelId;
    }

    @NotNull
    public Collection<Material> getMaterials(@NotNull IGeometryBakingContext owner, @NotNull Function<ResourceLocation, UnbakedModel> modelGetter, @NotNull Set<Pair<String, String>> missingTextureErrors) {
        this.overlayModel = modelGetter.apply(this.overlayModelId);
        if (this.overlayModel == null) {
            LOGGER.warn("No parent '{}' while loading model '{}'", (Object)this.overlayModelId, (Object)this);
        }
        if (this.overlayModel == null) {
            this.overlayModelId = ModelBakery.f_119230_;
            this.overlayModel = modelGetter.apply(this.overlayModelId);
        }
        if (!(this.overlayModel instanceof BlockModel)) {
            throw new IllegalStateException("BlockModel parent has to be a block model.");
        }
        return this.overlayModel.m_5500_(modelGetter, missingTextureErrors);
    }

    @NotNull
    public BakedModel bake(@NotNull IGeometryBakingContext owner, @NotNull ModelBakery bakery, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelTransform, @NotNull ItemOverrides overrides, @NotNull ResourceLocation modelLocation) {
        BakedModel baked = this.overlayModel.m_7611_(bakery, spriteGetter, modelTransform, this.overlayModelId);
        if (baked == null) {
            baked = Minecraft.m_91087_().m_91304_().m_119409_();
        }
        return new OverlaidBakedModel(baked);
    }
}

