/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.config.Configuration;
import com.ldtteam.structurize.event.ClientEventSubscriber;
import com.ldtteam.structurize.event.ClientLifecycleSubscriber;
import com.ldtteam.structurize.event.EventSubscriber;
import com.ldtteam.structurize.event.LifecycleSubscriber;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.network.messages.ClientBlueprintRequestMessage;
import com.ldtteam.structurize.proxy.ClientProxy;
import com.ldtteam.structurize.proxy.IProxy;
import com.ldtteam.structurize.proxy.ServerProxy;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.ServerStructurePackLoader;
import com.ldtteam.structurize.storage.rendering.ServerPreviewDistributor;
import net.minecraft.util.datafix.DataFixers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

@Mod(value="structurize")
public class Structurize {
    public static final IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static Configuration config;

    public Structurize() {
        config = new Configuration(ModLoadingContext.get().getActiveContainer());
        ModBlocks.getRegistry().register(FMLJavaModLoadingContext.get().getModEventBus());
        ModItems.getRegistry().register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlockEntities.getRegistry().register(FMLJavaModLoadingContext.get().getModEventBus());
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(LifecycleSubscriber.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(EventSubscriber.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientStructurePackLoader::onClientLoading);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> ServerStructurePackLoader::onServerStarting);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ServerStructurePackLoader.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientStructurePackLoader.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientBlueprintRequestMessage.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ServerPreviewDistributor.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ServerFutureProcessor.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientFutureProcessor.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(ClientLifecycleSubscriber.class));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientEventSubscriber.class));
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(this.getClass());
        BlueprintRenderSettings.instance.registerSetting("structurize.render.placeholders", false);
        BlueprintRenderSettings.instance.registerSetting("structurize.share.previews", false);
        BlueprintRenderSettings.instance.registerSetting("structurize.display.shared", false);
        if (DataFixerUtils.isVanillaDF) {
            if (DataFixers.m_14512_().getSchema(0x7FFFFFFE).getVersionKey() >= DataVersion.UPCOMING.getDataVersion() * 10) {
                throw new RuntimeException("You are trying to run old mod on much newer vanilla. Missing some newest data versions. Please update com/ldtteam/structures/blueprints/v1/DataVersion");
            }
            if (!FMLEnvironment.production && DataVersion.CURRENT == DataVersion.UPCOMING) {
                throw new RuntimeException("Missing some newest data versions. Please update com/ldtteam/structures/blueprints/v1/DataVersion");
            }
        } else {
            Log.getLogger().error("----------------------------------------------------------------- \n Invalid DataFixer detected, schematics might not paste correctly! \nThe following DataFixer was added: " + DataFixers.m_14512_().getClass() + "\n-----------------------------------------------------------------");
        }
    }

    @SubscribeEvent
    public static void preInit(@NotNull FMLCommonSetupEvent event) {
        Network.getNetwork().registerCommonMessages();
    }

    public static Configuration getConfig() {
        return config;
    }
}

