/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartManager;

public class SyncGearCraftingItemsPacket {
    private final Map<ResourceLocation, Ingredient> craftingItems = new HashMap<ResourceLocation, Ingredient>();

    public SyncGearCraftingItemsPacket() {
        this((Map)Util.m_137537_(() -> {
            HashMap map = new HashMap();
            PartManager.getValues().forEach(p -> map.put(p.getId(), p.getIngredient()));
            return map;
        }));
    }

    public SyncGearCraftingItemsPacket(Map<ResourceLocation, Ingredient> craftingItems) {
        this.craftingItems.putAll(craftingItems);
    }

    public static SyncGearCraftingItemsPacket fromBytes(FriendlyByteBuf buffer) {
        SilentGear.LOGGER.debug("Gear parts crafting items packet: {} bytes", (Object)buffer.readableBytes());
        SyncGearCraftingItemsPacket packet = new SyncGearCraftingItemsPacket();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            packet.craftingItems.put(buffer.m_130281_(), Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.craftingItems.size());
        this.craftingItems.forEach((id, material) -> {
            buffer.m_130085_(id);
            material.m_43923_(buffer);
        });
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        SilentGear.LOGGER.debug("Correcting part crafting items");
        this.craftingItems.forEach((id, ingredient) -> {
            IGearPart part = PartManager.get(id);
            if (part instanceof AbstractGearPart) {
                ((AbstractGearPart)part).updateCraftingItems((Ingredient)ingredient);
            }
        });
        context.get().setPacketHandled(true);
    }
}

