/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.item.gear.GearShovelItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearPickaxeItem
extends PickaxeItem
implements ICoreTool {
    private static final Set<Material> PICKAXE_EXTRA_MATERIALS = ImmutableSet.of((Object)Material.f_76278_, (Object)Material.f_76279_, (Object)Material.f_76281_, (Object)Material.f_76276_, (Object)Material.f_76316_, (Object)Material.f_76275_, (Object[])new Material[]{Material.f_76312_, Material.f_76283_, Material.f_76310_});
    public static final Set<ToolAction> ACTIONS_WITH_SPOON = GearHelper.makeToolActionSet(ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG);
    private final GearType gearType;
    private final Set<Material> extraMaterials;

    public GearPickaxeItem(GearType gearType) {
        this(gearType, PICKAXE_EXTRA_MATERIALS);
    }

    public GearPickaxeItem(GearType gearType, Set<Material> extraMaterials) {
        super((Tier)GearHelper.DEFAULT_DUMMY_TIER, 0, 0.0f, GearHelper.getBaseItemProperties());
        this.gearType = gearType;
        this.extraMaterials = Collections.unmodifiableSet(extraMaterials);
    }

    public Tier m_43314_() {
        return Config.Common.isLoaded() ? (Tier)Config.Common.dummyToolTier.get() : GearHelper.DEFAULT_DUMMY_TIER;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (GearHelper.isBroken(stack)) {
            return false;
        }
        if (TraitHelper.hasTrait(stack, Const.Traits.SPOON)) {
            return ACTIONS_WITH_SPOON.contains(toolAction);
        }
        return super.canPerformAction(stack, toolAction);
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (GearHelper.isBroken(context.m_43722_()) || context.m_43723_() != null && context.m_43723_().m_6047_()) {
            return InteractionResult.PASS;
        }
        InteractionResult result = GearHelper.onItemUse(context);
        if (result == InteractionResult.PASS) {
            return GearHelper.useAndCheckBroken(context, x$0 -> super.m_6225_(x$0));
        }
        return result;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (TraitHelper.hasTrait(stack, Const.Traits.SPOON) && ((GearShovelItem)SgItems.SHOVEL.get()).isCorrectToolForDrops(stack, state)) {
            return true;
        }
        return this.canPerformAction(stack, ToolActions.PICKAXE_DIG) && GearHelper.isCorrectToolForDrops(stack, state, (TagKey<Block>)BlockTags.f_144282_, this.extraMaterials);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return GearHelper.getDestroySpeed(stack, state, this.extraMaterials);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entity) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entity);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, this.getGearType().getDurabilityStat());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

