/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.utils.MathUtils;

public class GearBowItem
extends BowItem
implements ICoreRangedWeapon {
    private static final int MIN_DRAW_DELAY = 10;
    private static final int MAX_DRAW_DELAY = 100;

    public GearBowItem() {
        super(GearHelper.getBaseItemProperties().m_41499_(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.BOW;
    }

    @Override
    public float getDrawDelay(@Nonnull ItemStack stack) {
        return Mth.m_14036_((float)ICoreRangedWeapon.super.getDrawDelay(stack), (float)10.0f, (float)100.0f);
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / this.getDrawDelay(stack);
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.0f ? 1.0f : f;
    }

    public float getArrowDamage(ItemStack stack) {
        return GearData.getStat(stack, ItemStats.RANGED_DAMAGE);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.f_19853_.f_46443_) {
            float f = (float)(stack.m_41779_() - player.m_21212_()) / this.getDrawDelay(stack);
        }
        super.onUsingTick(stack, player, count);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (GearHelper.isBroken(itemstack)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        boolean flag = !player.m_6298_(itemstack).m_41619_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack) > 0;
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.m_150110_().f_35937_ && !flag) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (worldIn.f_46443_) {
            // empty if block
        }
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean infiniteAmmo = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack ammoItem = player.m_6298_(stack);
            int i = this.m_8105_(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)player, (int)i, (!ammoItem.m_41619_() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoItem.m_41619_() || infiniteAmmo) {
                float f;
                if (ammoItem.m_41619_()) {
                    ammoItem = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(f = this.getArrowVelocity(stack, i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || ammoItem.m_41720_() instanceof ArrowItem && ((ArrowItem)ammoItem.m_41720_()).isInfinite(ammoItem, stack, player);
                    if (!worldIn.f_46443_) {
                        int punchLevel;
                        int powerLevel;
                        ArrowItem arrowitem = (ArrowItem)(ammoItem.m_41720_() instanceof ArrowItem ? ammoItem.m_41720_() : Items.f_42412_);
                        AbstractArrow arrowEntity = arrowitem.m_6394_(worldIn, ammoItem, (LivingEntity)player);
                        arrowEntity.m_36781_(arrowEntity.m_36789_() - 2.0 + (double)GearData.getStat(stack, ItemStats.RANGED_DAMAGE));
                        arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
                        if (MathUtils.floatsEqual((float)f, (float)1.0f)) {
                            arrowEntity.m_36762_(true);
                        }
                        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                            arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
                        }
                        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                            arrowEntity.m_36735_(punchLevel);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            arrowEntity.m_20254_(100);
                        }
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                        if (flag1 || player.m_150110_().f_35937_ && (ammoItem.m_41720_() == Items.f_42737_ || ammoItem.m_41720_() == Items.f_42738_)) {
                            arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.m_7967_((Entity)arrowEntity);
                    }
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        ammoItem.m_41774_(1);
                        if (ammoItem.m_41619_()) {
                            player.m_150109_().m_36057_(ammoItem);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, false);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

