/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.silentchaos512.gear.init.SgMenuTypes;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;

public class BlueprintBookContainer
extends AbstractContainerMenu {
    final ItemStack item;
    private final IItemHandler itemHandler;
    int bookSlot = -1;

    public BlueprintBookContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, data.m_130267_());
    }

    BlueprintBookContainer(int id, Inventory playerInventory, ItemStack stack) {
        super((MenuType)SgMenuTypes.BLUEPRINT_BOOK.get(), id);
        int y;
        this.item = stack;
        final IContainerItem containerItem = (IContainerItem)this.item.m_41720_();
        this.itemHandler = containerItem.getInventory(this.item);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = 8 + 18 * (i % 9);
            y = 18 + 18 * (i / 9);
            this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, i, x, y){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return containerItem.canStore(stack);
                }
            });
        }
        int rowCount = this.itemHandler.getSlots() / 9;
        int yOffset = (rowCount - 4) * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 103 + y * 18 + yOffset));
            }
        }
        for (int x = 0; x < 9; ++x) {
            Slot slot = this.m_38897_(new Slot((Container)playerInventory, x, 8 + x * 18, 161 + yOffset){

                public boolean m_8010_(Player playerIn) {
                    return this.f_40219_ != BlueprintBookContainer.this.bookSlot;
                }
            });
            if (x != playerInventory.f_35977_ || !ItemStack.m_41728_((ItemStack)playerInventory.m_36056_(), (ItemStack)this.item)) continue;
            this.bookSlot = slot.f_40219_;
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = this.m_38853_(index);
        if (!slot.m_8010_(playerIn)) {
            return slot.m_7993_();
        }
        if (index == this.bookSlot || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack newStack = stack.m_41777_();
        int containerSlots = this.itemHandler.getSlots();
        if (index < containerSlots) {
            if (!this.m_38903_(stack, containerSlots, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            slot.m_6654_();
        } else if (!this.m_38903_(stack, 0, containerSlots, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(playerIn, newStack);
        return newStack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 0 || slotId > this.f_38839_.size()) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (!this.canTake(slotId, slot, dragType, player, clickTypeIn)) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        ((IContainerItem)this.item.m_41720_()).saveInventory(this.item, this.itemHandler);
    }

    public boolean canTake(int slotId, Slot slot, int button, Player player, ClickType clickType) {
        if (slotId == this.bookSlot) {
            return false;
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = this.itemHandler.getSlots() + 27 + button;
            if (this.bookSlot == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.m_38853_(hotbarId);
            if (slotId <= this.itemHandler.getSlots() - 1) {
                return !BlueprintBookContainer.isContainerItem(slot.m_7993_()) && !BlueprintBookContainer.isContainerItem(hotbarSlot.m_7993_());
            }
        }
        return true;
    }

    private static boolean isContainerItem(ItemStack stack) {
        return stack.m_41720_() instanceof BlueprintBookItem;
    }
}

