/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TextUtil;

public class RepairKitItem
extends Item {
    private static final String NBT_STORAGE = "Storage";
    private final Supplier<Integer> capacity;
    private final Supplier<Double> efficiency;

    public RepairKitItem(Supplier<Integer> capacity, Supplier<Double> efficiency, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.efficiency = efficiency;
    }

    public boolean addMaterial(ItemStack repairKit, ItemStack materialStack) {
        Tuple<IMaterialInstance, Float> tuple = RepairKitItem.getMaterialAndValue(materialStack);
        if (tuple != null) {
            IMaterialInstance mat = (IMaterialInstance)tuple.m_14418_();
            float value = ((Float)tuple.m_14419_()).floatValue();
            if (RepairKitItem.getStoredMaterialAmount(repairKit) > (float)this.getKitCapacity() - value) {
                return false;
            }
            String key = RepairKitItem.getShorthandKey(mat);
            CompoundTag storageTag = repairKit.m_41698_(NBT_STORAGE);
            float current = storageTag.m_128457_(key);
            storageTag.m_128350_(key, current + value);
            return true;
        }
        return false;
    }

    @Nullable
    private static Tuple<IMaterialInstance, Float> getMaterialAndValue(ItemStack stack) {
        if (stack.m_41720_() instanceof FragmentItem) {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            if (material != null) {
                return new Tuple((Object)material, (Object)Float.valueOf(0.125f));
            }
            return null;
        }
        MaterialInstance mat = MaterialInstance.from(stack);
        if (mat != null) {
            return new Tuple((Object)mat, (Object)Float.valueOf(1.0f));
        }
        return null;
    }

    private int getKitCapacity() {
        return this.capacity.get();
    }

    public float getRepairEfficiency(RepairContext.Type repairType) {
        return this.efficiency.get().floatValue() + repairType.getBonusEfficiency();
    }

    private static float getStoredAmount(ItemStack stack, MaterialInstance material) {
        CompoundTag nbt = stack.m_41698_(NBT_STORAGE);
        return nbt.m_128457_(RepairKitItem.getShorthandKey(material));
    }

    private static float getStoredMaterialAmount(ItemStack repairKit) {
        float sum = 0.0f;
        for (float amount : RepairKitItem.getStoredMaterials(repairKit).values()) {
            sum += amount;
        }
        return sum;
    }

    private static Map<MaterialInstance, Float> getStoredMaterials(ItemStack stack) {
        CompoundTag nbt = stack.m_41698_(NBT_STORAGE);
        List<MaterialInstance> list = nbt.m_128431_().stream().map(MaterialInstance::readShorthand).filter(Objects::nonNull).sorted(Comparator.comparing(mat1 -> mat1.getTier(PartType.MAIN)).thenComparing(mat1 -> mat1.getDisplayName(PartType.MAIN, ItemStack.f_41583_).m_6879_().getString())).collect(Collectors.toList());
        LinkedHashMap<MaterialInstance, Float> ret = new LinkedHashMap<MaterialInstance, Float>();
        list.forEach(mat -> {
            float value = nbt.m_128457_(RepairKitItem.getShorthandKey(mat));
            ret.put((MaterialInstance)mat, Float.valueOf(value));
        });
        return ret;
    }

    @Nonnull
    private static String getShorthandKey(IMaterialInstance mat) {
        return MaterialInstance.writeShorthand(mat);
    }

    private Pair<Map<MaterialInstance, Float>, Integer> getMaterialsToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        Map<MaterialInstance, Float> stored = RepairKitItem.getStoredMaterials(repairKit);
        HashMap<MaterialInstance, Float> used = new HashMap<MaterialInstance, Float>();
        float gearRepairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY);
        float kitEfficiency = this.getRepairEfficiency(repairType);
        int damageLeft = gear.m_41773_();
        if (gearRepairEfficiency > 0.0f && kitEfficiency > 0.0f) {
            for (Map.Entry<MaterialInstance, Float> entry : stored.entrySet()) {
                MaterialInstance mat = entry.getKey();
                float amount = entry.getValue().floatValue();
                int repairValue = mat.getRepairValue(gear);
                if (repairValue <= 0) continue;
                float totalRepairValue = (float)repairValue * amount;
                int maxRepair = Math.round(totalRepairValue * gearRepairEfficiency * kitEfficiency);
                int toRepair = Math.min(maxRepair, damageLeft);
                float repairValueUsed = (float)toRepair / gearRepairEfficiency / kitEfficiency;
                float amountUsed = repairValueUsed / (float)repairValue;
                used.put(mat, Float.valueOf(amountUsed));
                if ((damageLeft -= toRepair) > 0) continue;
                break;
            }
        }
        return Pair.of(used, (Object)(gear.m_41773_() - damageLeft));
    }

    public Map<MaterialInstance, Float> getRepairMaterials(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Map)this.getMaterialsToRepair(gear, repairKit, repairType).getFirst();
    }

    public int getDamageToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Integer)this.getMaterialsToRepair(gear, repairKit, repairType).getSecond();
    }

    public void removeRepairMaterials(ItemStack repairKit, Map<MaterialInstance, Float> toRemove) {
        CompoundTag nbt = repairKit.m_41698_(NBT_STORAGE);
        for (Map.Entry<MaterialInstance, Float> entry : toRemove.entrySet()) {
            MaterialInstance mat = entry.getKey();
            Float amount = entry.getValue();
            String key = RepairKitItem.getShorthandKey(mat);
            float newValue = nbt.m_128457_(key) - amount.floatValue();
            if (newValue < 0.01f) {
                nbt.m_128473_(key);
                continue;
            }
            nbt.m_128350_(key, newValue);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TextUtil.translate("item", "repair_kit.efficiency", (int)(this.getRepairEfficiency(RepairContext.Type.QUICK) * 100.0f)));
        tooltip.add((Component)TextUtil.translate("item", "repair_kit.capacity", RepairKitItem.format(RepairKitItem.getStoredMaterialAmount(stack)), this.getKitCapacity()));
        Map<MaterialInstance, Float> storedMaterials = RepairKitItem.getStoredMaterials(stack);
        if (storedMaterials.isEmpty()) {
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint1").m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint2").m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint3").m_130940_(ChatFormatting.ITALIC));
            return;
        }
        for (Map.Entry<MaterialInstance, Float> entry : storedMaterials.entrySet()) {
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.material", entry.getKey().getDisplayNameWithModifiers(PartType.MAIN, ItemStack.f_41583_), RepairKitItem.format(entry.getValue().floatValue())));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * RepairKitItem.getStoredMaterialAmount(stack) / (float)this.getKitCapacity());
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (13.0f - (float)this.m_142158_(stack)) / 13.0f) / 3.0f + 0.5f), (float)1.0f, (float)1.0f);
    }

    private static String format(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }
}

