/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;

public class CustomMaterialItem
extends Item
implements IColoredMaterialItem {
    private static final String NBT_MATERIAL = "Material";

    public CustomMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack create(IMaterialInstance material) {
        return this.create(material, 1);
    }

    public ItemStack create(IMaterialInstance material, int count) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(NBT_MATERIAL, SilentGear.shortenId(material.getId()));
        ItemStack result = new ItemStack((ItemLike)this, count);
        result.m_41751_(tag);
        return result;
    }

    @Nullable
    public static MaterialInstance getMaterial(ItemStack stack) {
        IMaterial material;
        String str = stack.m_41784_().m_128461_(NBT_MATERIAL);
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(str);
        if (id != null && (material = MaterialManager.get(id)) != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        MaterialInstance material;
        if (layer == 0 && (material = CustomMaterialItem.getMaterial(stack)) != null) {
            return material.getPrimaryColor(GearType.ALL, PartType.MAIN);
        }
        return 0xFFFFFF;
    }

    public Component m_7626_(ItemStack stack) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (material != null) {
            return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{material.getDisplayName(PartType.MAIN)});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.create(LazyMaterialInstance.of(Const.Materials.EXAMPLE)));
            for (IMaterial material : MaterialManager.getValues()) {
                if (!(material instanceof CustomCompoundMaterial)) continue;
                MaterialInstance mat = MaterialInstance.of(material);
                ItemStack stack = this.create(mat);
                if (!mat.getIngredient().test(stack)) continue;
                items.add((Object)stack);
            }
        }
    }
}

