/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.FluffyBlock;
import net.silentchaos512.gear.block.GearSmithingTableBlock;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.block.ModOreBlock;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.WoodBlock;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.charger.StarlightChargerBlock;
import net.silentchaos512.gear.block.compounder.CompounderBlock;
import net.silentchaos512.gear.block.grader.GraderBlock;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.lib.util.NameUtils;

@Mod.EventBusSubscriber(modid="silentgear", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class SgBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"silentgear");
    private static final Map<Block, Block> STRIPPED_WOOD = new HashMap<Block, Block>();
    public static final BlockRegistryObject<DropExperienceBlock> BORT_ORE = SgBlocks.register("bort_ore", () -> SgBlocks.getOre(SoundType.f_56742_));
    public static final BlockRegistryObject<DropExperienceBlock> DEEPSLATE_BORT_ORE = SgBlocks.register("deepslate_bort_ore", () -> SgBlocks.getOre(SoundType.f_56742_));
    public static final BlockRegistryObject<DropExperienceBlock> CRIMSON_IRON_ORE = SgBlocks.register("crimson_iron_ore", () -> SgBlocks.getOre(SoundType.f_56729_));
    public static final BlockRegistryObject<DropExperienceBlock> BLACKSTONE_CRIMSON_IRON_ORE = SgBlocks.register("blackstone_crimson_iron_ore", () -> SgBlocks.getOre(SoundType.f_56730_));
    public static final BlockRegistryObject<DropExperienceBlock> AZURE_SILVER_ORE = SgBlocks.register("azure_silver_ore", () -> SgBlocks.getOre(SoundType.f_56742_));
    public static final BlockRegistryObject<Block> RAW_CRIMSON_IRON_BLOCK = SgBlocks.register("raw_crimson_iron_block", () -> SgBlocks.getRawOreBlock(SoundType.f_56729_));
    public static final BlockRegistryObject<Block> RAW_AZURE_SILVER_BLOCK = SgBlocks.register("raw_azure_silver_block", () -> SgBlocks.getRawOreBlock(SoundType.f_56742_));
    public static final BlockRegistryObject<Block> BORT_BLOCK = SgBlocks.register("bort_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> CRIMSON_IRON_BLOCK = SgBlocks.register("crimson_iron_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> CRIMSON_STEEL_BLOCK = SgBlocks.register("crimson_steel_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> BLAZE_GOLD_BLOCK = SgBlocks.register("blaze_gold_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> AZURE_SILVER_BLOCK = SgBlocks.register("azure_silver_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> AZURE_ELECTRUM_BLOCK = SgBlocks.register("azure_electrum_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> TYRIAN_STEEL_BLOCK = SgBlocks.register("tyrian_steel_block", SgBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> GEAR_SMITHING_TABLE = SgBlocks.register("gear_smithing_table", () -> new GearSmithingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
    public static final BlockRegistryObject<GraderBlock> MATERIAL_GRADER = SgBlocks.register("material_grader", () -> new GraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 30.0f)));
    public static final BlockRegistryObject<SalvagerBlock> SALVAGER = SgBlocks.register("salvager", () -> new SalvagerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 30.0f)));
    public static final BlockRegistryObject<StarlightChargerBlock> STARLIGHT_CHARGER = SgBlocks.register("starlight_charger", () -> new StarlightChargerBlock((BlockEntityType.BlockEntitySupplier<ChargerTileEntity>)((BlockEntityType.BlockEntitySupplier)ChargerTileEntity::createStarlightCharger), BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 30.0f)));
    public static final BlockRegistryObject<CompounderBlock<MetalCompoundingRecipe>> METAL_ALLOYER = SgBlocks.register("metal_alloyer", () -> new CompounderBlock<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 20.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockRegistryObject<CompounderBlock<GemCompoundingRecipe>> RECRYSTALLIZER = SgBlocks.register("recrystallizer", () -> new CompounderBlock<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 20.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockRegistryObject<CompounderBlock<FabricCompoundingRecipe>> REFABRICATOR = SgBlocks.register("refabricator", () -> new CompounderBlock<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 20.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockRegistryObject<MetalPressBlock> METAL_PRESS = SgBlocks.register("metal_press", () -> new MetalPressBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 20.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockRegistryObject<ModCropBlock> FLAX_PLANT = SgBlocks.registerNoItem("flax_plant", () -> new ModCropBlock(() -> SgItems.FLAX_SEEDS.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60910_().m_60977_().m_60918_(SoundType.f_56758_)));
    public static final BlockRegistryObject<BushBlock> WILD_FLAX_PLANT = SgBlocks.registerNoItem("wild_flax_plant", () -> new BushBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60910_().m_60918_(SoundType.f_56758_)));
    public static final BlockRegistryObject<ModCropBlock> FLUFFY_PLANT = SgBlocks.registerNoItem("fluffy_plant", () -> new ModCropBlock(() -> SgItems.FLUFFY_SEEDS.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60910_().m_60977_().m_60918_(SoundType.f_56758_)));
    public static final BlockRegistryObject<BushBlock> WILD_FLUFFY_PLANT = SgBlocks.registerNoItem("wild_fluffy_plant", () -> new BushBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60910_().m_60918_(SoundType.f_56758_)));
    public static final BlockRegistryObject<FluffyBlock> WHITE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.WHITE);
    public static final BlockRegistryObject<FluffyBlock> ORANGE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.ORANGE);
    public static final BlockRegistryObject<FluffyBlock> MAGENTA_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.MAGENTA);
    public static final BlockRegistryObject<FluffyBlock> LIGHT_BLUE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIGHT_BLUE);
    public static final BlockRegistryObject<FluffyBlock> YELLOW_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.YELLOW);
    public static final BlockRegistryObject<FluffyBlock> LIME_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIME);
    public static final BlockRegistryObject<FluffyBlock> PINK_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.PINK);
    public static final BlockRegistryObject<FluffyBlock> GRAY_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.GRAY);
    public static final BlockRegistryObject<FluffyBlock> LIGHT_GRAY_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIGHT_GRAY);
    public static final BlockRegistryObject<FluffyBlock> CYAN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.CYAN);
    public static final BlockRegistryObject<FluffyBlock> PURPLE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.PURPLE);
    public static final BlockRegistryObject<FluffyBlock> BLUE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BLUE);
    public static final BlockRegistryObject<FluffyBlock> BROWN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BROWN);
    public static final BlockRegistryObject<FluffyBlock> GREEN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.GREEN);
    public static final BlockRegistryObject<FluffyBlock> RED_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.RED);
    public static final BlockRegistryObject<FluffyBlock> BLACK_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BLACK);
    public static final BlockRegistryObject<TorchBlock> STONE_TORCH = SgBlocks.register("stone_torch", () -> new TorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.0f).m_60953_(state -> 14).m_60918_(SoundType.f_56742_), (ParticleOptions)ParticleTypes.f_123744_), bro -> SgBlocks.getStoneTorchItem());
    public static final BlockRegistryObject<WallTorchBlock> WALL_STONE_TORCH = SgBlocks.registerNoItem("wall_stone_torch", () -> new WallTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.0f).m_60953_(state -> 14).m_60918_(SoundType.f_56742_).lootFrom(() -> STONE_TORCH.get()), (ParticleOptions)ParticleTypes.f_123744_));
    public static final BlockRegistryObject<Block> NETHERWOOD_CHARCOAL_BLOCK = SgBlocks.register("netherwood_charcoal_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(5.0f, 6.0f)), bro -> () -> new BlockItem((Block)bro.get(), new Item.Properties().m_41491_(SilentGear.ITEM_GROUP)){

        public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
            return 10 * (Integer)Config.Common.netherwoodCharcoalBurnTime.get();
        }
    });
    public static final BlockRegistryObject<WoodBlock> NETHERWOOD_LOG = SgBlocks.register("netherwood_log", () -> new WoodBlock(STRIPPED_WOOD::get, SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<RotatedPillarBlock> STRIPPED_NETHERWOOD_LOG = SgBlocks.register("stripped_netherwood_log", () -> new RotatedPillarBlock(SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<WoodBlock> NETHERWOOD_WOOD = SgBlocks.register("netherwood_wood", () -> new WoodBlock(STRIPPED_WOOD::get, SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<RotatedPillarBlock> STRIPPED_NETHERWOOD_WOOD = SgBlocks.register("stripped_netherwood_wood", () -> new RotatedPillarBlock(SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<Block> NETHERWOOD_PLANKS = SgBlocks.register("netherwood_planks", () -> new Block(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<SlabBlock> NETHERWOOD_SLAB = SgBlocks.register("netherwood_slab", () -> new SlabBlock(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<StairBlock> NETHERWOOD_STAIRS = SgBlocks.register("netherwood_stairs", () -> new StairBlock(() -> NETHERWOOD_PLANKS.asBlockState(), SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<FenceBlock> NETHERWOOD_FENCE = SgBlocks.register("netherwood_fence", () -> new FenceBlock(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<FenceGateBlock> NETHERWOOD_FENCE_GATE = SgBlocks.register("netherwood_fence_gate", () -> new FenceGateBlock(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<DoorBlock> NETHERWOOD_DOOR = SgBlocks.register("netherwood_door", () -> new DoorBlock(SgBlocks.netherWoodProps(3.0f, 3.0f).m_60955_()));
    public static final BlockRegistryObject<TrapDoorBlock> NETHERWOOD_TRAPDOOR = SgBlocks.register("netherwood_trapdoor", () -> new TrapDoorBlock(SgBlocks.netherWoodProps(3.0f, 3.0f).m_60955_()));
    public static final BlockRegistryObject<LeavesBlock> NETHERWOOD_LEAVES = SgBlocks.register("netherwood_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60955_().m_60918_(SoundType.f_56740_)));
    public static final BlockRegistryObject<NetherwoodSapling> NETHERWOOD_SAPLING = SgBlocks.register("netherwood_sapling", () -> new NetherwoodSapling(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60910_().m_60977_().m_60918_(SoundType.f_56740_)));
    public static final BlockRegistryObject<FlowerPotBlock> POTTED_NETHERWOOD_SAPLING = SgBlocks.registerNoItem("potted_netherwood_sapling", () -> SgBlocks.makePottedPlant(NETHERWOOD_SAPLING));
    public static final BlockRegistryObject<PhantomLight> PHANTOM_LIGHT = SgBlocks.register("phantom_light", PhantomLight::new);

    private SgBlocks() {
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        STRIPPED_WOOD.put((Block)NETHERWOOD_LOG.get(), (Block)STRIPPED_NETHERWOOD_LOG.get());
        STRIPPED_WOOD.put((Block)NETHERWOOD_WOOD.get(), (Block)STRIPPED_NETHERWOOD_WOOD.get());
    }

    private static DropExperienceBlock getOre(SoundType soundType) {
        return new ModOreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(4.0f, 10.0f).m_60999_().m_60918_(soundType));
    }

    private static Block getRawOreBlock(SoundType soundType) {
        return new ModOreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(4.0f, 20.0f).m_60999_().m_60918_(soundType));
    }

    private static Block getStorageBlock() {
        return new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_));
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return SgBlocks.register(name, block, SgBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = SgBlocks.registerNoItem(name, block);
        SgItems.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static BlockRegistryObject<FluffyBlock> registerFluffyBlock(DyeColor color) {
        return SgBlocks.register(color.m_41065_() + "_fluffy_block", () -> new FluffyBlock(color));
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(SilentGear.ITEM_GROUP));
    }

    private static Supplier<BlockItem> getStoneTorchItem() {
        return () -> new StandingAndWallBlockItem((Block)STONE_TORCH.get(), (Block)WALL_STONE_TORCH.get(), new Item.Properties().m_41491_(SilentGear.ITEM_GROUP));
    }

    private static FlowerPotBlock makePottedPlant(Supplier<? extends Block> flower) {
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, flower, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.0f));
        ResourceLocation flowerId = NameUtils.fromBlock((Block)flower.get());
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(flowerId, () -> potted);
        return potted;
    }

    private static BlockBehaviour.Properties netherWoodProps(float hardnessIn, float resistanceIn) {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76321_).m_60913_(hardnessIn, resistanceIn).m_60918_(SoundType.f_56736_);
    }

    public static <T extends Block> Collection<T> getBlocks(Class<T> clazz) {
        return BLOCKS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(block -> block).collect(Collectors.toList());
    }
}

