/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.network.SyncTraitsPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class TraitManager
implements ResourceManagerReloadListener {
    public static final TraitManager INSTANCE = new TraitManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"TraitManager");
    private static final String DATA_PATH = "silentgear_traits";
    private static final Map<ResourceLocation, ITrait> TRAITS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    private TraitManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Map resources = resourceManager.m_214159_(DATA_PATH, s -> s.toString().endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        TRAITS.clear();
        ERROR_LIST.clear();
        SilentGear.LOGGER.info(MARKER, "Reloading trait files");
        Map<ResourceLocation, ITrait> map = TRAITS;
        synchronized (map) {
            for (ResourceLocation id : resources.keySet()) {
                String path = id.m_135815_().substring(DATA_PATH.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                Optional resourceOptional = resourceManager.m_213713_(id);
                if (!resourceOptional.isPresent()) continue;
                Resource iresource = (Resource)resourceOptional.get();
                if (SilentGear.LOGGER.isTraceEnabled()) {
                    SilentGear.LOGGER.trace(MARKER, "Found likely trait file: {}, trying to read as trait {}", (Object)id, (Object)name);
                }
                JsonObject json = null;
                try {
                    json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_215507_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read trait {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(name);
                }
                if (json == null) {
                    SilentGear.LOGGER.error(MARKER, "could not load trait {} as it's null or empty", (Object)name);
                    continue;
                }
                TraitManager.addTrait(TraitSerializers.deserialize(name, json));
            }
        }
        SilentGear.LOGGER.info(MARKER, "Registered {} traits", (Object)TRAITS.size());
    }

    private static void addTrait(ITrait trait) {
        if (TRAITS.containsKey(trait.getId())) {
            throw new IllegalArgumentException("Duplicate trait " + trait.getId());
        }
        TRAITS.put(trait.getId(), trait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ResourceLocation> getKeys() {
        Map<ResourceLocation, ITrait> map = TRAITS;
        synchronized (map) {
            return TRAITS.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ITrait> getValues() {
        Map<ResourceLocation, ITrait> map = TRAITS;
        synchronized (map) {
            return TRAITS.values();
        }
    }

    @Nullable
    public static ITrait get(ResourceLocation id) {
        return TRAITS.get(id);
    }

    @Nullable
    public static ITrait get(String strId) {
        return TraitManager.get(new ResourceLocation(strId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleTraitSyncPacket(SyncTraitsPacket packet, Supplier<NetworkEvent.Context> context) {
        Map<ResourceLocation, ITrait> map = TRAITS;
        synchronized (map) {
            ImmutableMap oldTraits = ImmutableMap.copyOf(TRAITS);
            TRAITS.clear();
            for (ITrait trait : packet.getTraits()) {
                trait.retainData((ITrait)oldTraits.get(trait.getId()));
                TRAITS.put(trait.getId(), trait);
            }
            SilentGear.LOGGER.info("Read {} traits from server", (Object)TRAITS.size());
        }
        context.get().setPacketHandled(true);
    }

    public static Collection<Component> getErrorMessages(ServerPlayer player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)Component.m_237113_((String)"[Silent Gear] The following traits failed to load, check your log file:").m_130940_(ChatFormatting.RED), (Object)Component.m_237113_((String)listStr));
        }
        return ImmutableList.of();
    }
}

