/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;

public class BlockFillerTrait
extends SimpleTrait {
    public static final ITraitSerializer<BlockFillerTrait> SERIALIZER = new SimpleTrait.Serializer<BlockFillerTrait>(ApiConst.BLOCK_FILLER_TRAIT_ID, BlockFillerTrait::new, BlockFillerTrait::readJson, BlockFillerTrait::read, BlockFillerTrait::write);
    @Nullable
    private Block targetBlock;
    @Nullable
    private TagKey<Block> targetBlockTag;
    private Block fillBlock;
    private boolean replaceTileEntities;
    private int fillRangeX;
    private int fillRangeY;
    private int fillRangeZ;
    private boolean fillFacingPlaneOnly;
    private SneakMode sneakMode;
    private float damageOnUse;
    private int cooldown;
    private SoundEvent sound = SoundEvents.f_12019_;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public BlockFillerTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        boolean hasEnoughDurability;
        Player player = context.m_43723_();
        if (player != null && player.m_6144_() && this.sneakMode == SneakMode.PASS) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos center = context.m_8083_();
        int rangeX = this.shouldConstrain(context, Direction.Axis.X) ? 0 : this.fillRangeX;
        int rangeY = this.shouldConstrain(context, Direction.Axis.Y) ? 0 : this.fillRangeY;
        int rangeZ = this.shouldConstrain(context, Direction.Axis.Z) ? 0 : this.fillRangeZ;
        int replaceCount = this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, true);
        int durabilityCost = Math.round(this.damageOnUse * (float)replaceCount);
        boolean bl = hasEnoughDurability = durabilityCost < 1 || stack.m_41773_() < stack.m_41776_() - durabilityCost;
        if (player != null && player.f_19853_.f_46443_) {
            return replaceCount > 0 && hasEnoughDurability ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (hasEnoughDurability) {
            this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, false);
        }
        if (replaceCount > 0) {
            if (this.damageOnUse > 0.0f) {
                GearHelper.attemptDamage(stack, durabilityCost, (LivingEntity)player, context.m_43724_());
            }
            if (this.sound != null) {
                float pitch = (float)((double)this.soundPitch * (1.0 + 0.05 * SilentGear.RANDOM.nextGaussian()));
                world.m_5594_(null, center, this.sound, SoundSource.BLOCKS, this.soundVolume, pitch);
            }
            if (this.cooldown > 0 && player != null) {
                player.m_36335_().m_41524_(stack.m_41720_(), this.cooldown);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int replaceBlocks(UseOnContext context, ItemStack stack, Level world, BlockPos center, int rangeX, int rangeY, int rangeZ, boolean simulate) {
        int count = 0;
        for (int x = center.m_123341_() - rangeX; x <= center.m_123341_() + rangeX; ++x) {
            for (int y = center.m_123342_() - rangeY; y <= center.m_123342_() + rangeY; ++y) {
                for (int z = center.m_123343_() - rangeZ; z <= center.m_123343_() + rangeZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    if (!this.canReplace(state) || !this.replaceTileEntities && world.m_7702_(pos) != null) continue;
                    if (!simulate) {
                        world.m_7731_(pos, this.fillBlock.m_49966_(), 11);
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean shouldConstrain(UseOnContext context, Direction.Axis axis) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_() && this.sneakMode == SneakMode.CONSTRAIN) {
            return true;
        }
        return this.fillFacingPlaneOnly && context.m_43719_().m_122434_() == axis;
    }

    private boolean canReplace(BlockState state) {
        return this.targetBlockTag != null && state.m_204336_(this.targetBlockTag) || this.targetBlock != null && state.m_60713_(this.targetBlock);
    }

    private static void readJson(BlockFillerTrait trait, JsonObject json) {
        JsonObject targetJson = GsonHelper.m_13930_((JsonObject)json, (String)"target");
        if (targetJson.has("tag")) {
            trait.targetBlockTag = BlockTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)targetJson, (String)"tag")));
        }
        if (targetJson.has("block")) {
            trait.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)targetJson, (String)"block")));
        }
        trait.fillBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fill_block")));
        trait.replaceTileEntities = GsonHelper.m_13855_((JsonObject)json, (String)"replace_tile_entities", (boolean)false);
        trait.fillRangeX = GsonHelper.m_13824_((JsonObject)json, (String)"fill_spread_x", (int)0);
        trait.fillRangeY = GsonHelper.m_13824_((JsonObject)json, (String)"fill_spread_y", (int)0);
        trait.fillRangeZ = GsonHelper.m_13824_((JsonObject)json, (String)"fill_spread_z", (int)0);
        trait.fillFacingPlaneOnly = GsonHelper.m_13855_((JsonObject)json, (String)"fill_facing_plane_only", (boolean)false);
        trait.sneakMode = SneakMode.byName(GsonHelper.m_13851_((JsonObject)json, (String)"sneak_mode", (String)"pass"));
        trait.damageOnUse = GsonHelper.m_13915_((JsonObject)json, (String)"damage_on_use");
        trait.cooldown = GsonHelper.m_13824_((JsonObject)json, (String)"cooldown", (int)0);
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"sound")));
        trait.soundVolume = GsonHelper.m_13915_((JsonObject)json, (String)"sound_volume");
        trait.soundPitch = GsonHelper.m_13915_((JsonObject)json, (String)"sound_pitch");
    }

    private static void read(BlockFillerTrait trait, FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            trait.targetBlockTag = BlockTags.create((ResourceLocation)buffer.m_130281_());
        }
        if (buffer.readBoolean()) {
            trait.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        }
        trait.fillBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        trait.replaceTileEntities = buffer.readBoolean();
        trait.fillRangeX = buffer.readByte();
        trait.fillRangeY = buffer.readByte();
        trait.fillRangeZ = buffer.readByte();
        trait.fillFacingPlaneOnly = buffer.readBoolean();
        trait.sneakMode = (SneakMode)buffer.m_130066_(SneakMode.class);
        trait.damageOnUse = buffer.readFloat();
        trait.cooldown = buffer.m_130242_();
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_());
        trait.soundVolume = buffer.readFloat();
        trait.soundPitch = buffer.readFloat();
    }

    private static void write(BlockFillerTrait trait, FriendlyByteBuf buffer) {
        buffer.writeBoolean(trait.targetBlockTag != null);
        if (trait.targetBlockTag != null) {
            buffer.m_130085_(trait.targetBlockTag.f_203868_());
        }
        buffer.writeBoolean(trait.targetBlock != null);
        if (trait.targetBlock != null) {
            buffer.m_130085_(NameUtils.fromBlock((Block)trait.targetBlock));
        }
        buffer.m_130085_(NameUtils.fromBlock((Block)trait.fillBlock));
        buffer.writeBoolean(trait.replaceTileEntities);
        buffer.writeByte(trait.fillRangeX);
        buffer.writeByte(trait.fillRangeY);
        buffer.writeByte(trait.fillRangeZ);
        buffer.writeBoolean(trait.fillFacingPlaneOnly);
        buffer.m_130068_((Enum)trait.sneakMode);
        buffer.writeFloat(trait.damageOnUse);
        buffer.m_130130_(trait.cooldown);
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)trait.sound)));
        buffer.writeFloat(trait.soundVolume);
        buffer.writeFloat(trait.soundPitch);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Fills with: " + NameUtils.fromBlock((Block)this.fillBlock));
        ret.add("  - Replaces");
        if (this.targetBlockTag != null) {
            ret.add("    - Tag: " + this.targetBlockTag.f_203868_());
        }
        if (this.targetBlock != null) {
            ret.add("    - Block: " + NameUtils.fromBlock((Block)this.targetBlock));
        }
        ret.add("    - " + (this.replaceTileEntities ? "Replaces" : "Does not replace") + " tile entities");
        int fillX = 2 * this.fillRangeX + 1;
        int fillY = 2 * this.fillRangeY + 1;
        int fillZ = 2 * this.fillRangeZ + 1;
        ret.add("  - Fill Area");
        ret.add("    - X: " + fillX + " (+" + this.fillRangeX + ")");
        ret.add("    - Y: " + fillY + " (+" + this.fillRangeY + ")");
        ret.add("    - Z: " + fillZ + " (+" + this.fillRangeZ + ")");
        if (this.fillFacingPlaneOnly) {
            ret.add("    - Fills facing plane only");
        }
        ret.add("    - On sneak: " + this.sneakMode.name());
        ret.add("  - Durability Cost: " + this.damageOnUse);
        if (this.cooldown > 0) {
            ret.add("  - Cooldown: " + this.cooldown);
        }
        return ret;
    }

    public static enum SneakMode {
        PASS,
        CONSTRAIN,
        IGNORE;


        static SneakMode byName(String name) {
            for (SneakMode value : SneakMode.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return IGNORE;
        }
    }
}

