/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialModifiers;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class StarchargedMaterialModifier
extends ChargedMaterialModifier {
    public StarchargedMaterialModifier(int level) {
        super(level);
    }

    @Override
    public IMaterialModifierType<?> getType() {
        return MaterialModifiers.STARCHARGED;
    }

    @Override
    public List<StatInstance> modifyStats(IMaterialInstance material, PartType partType, StatGearKey key, List<StatInstance> statMods) {
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>();
        if (key.getStat() == ItemStats.CHARGING_VALUE) {
            return ret;
        }
        for (StatInstance mod : statMods) {
            StatInstance newMod = StarchargedMaterialModifier.modifyStat(key, mod, this.getChargedProperties(material));
            ret.add(newMod != null ? newMod : mod);
        }
        return ret;
    }

    @Override
    public void appendTooltip(List<Component> tooltip) {
        MutableComponent text = this.getNameWithLevel();
        tooltip.add((Component)TextUtil.withColor(text, Color.AQUAMARINE));
    }

    @Override
    public MutableComponent modifyMaterialName(MutableComponent name) {
        return this.getNameWithLevel().m_130946_(" ").m_7220_((Component)name);
    }

    private MutableComponent getNameWithLevel() {
        MutableComponent text = TextUtil.translate("materialModifier", "starcharged");
        text.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + this.level)));
        return text;
    }

    @Nullable
    private static StatInstance modifyStat(StatGearKey stat, StatInstance mod, ChargedProperties charge) {
        if (stat.getStat() == ItemStats.CHARGING_VALUE) {
            return null;
        }
        if (StarchargedMaterialModifier.isSupportedModifierOp(mod)) {
            SplitItemStat splitItemStat;
            float modifiedStatValue = (float)StarchargedMaterialModifier.getModifiedStatValue(stat, mod, charge);
            IItemStat iItemStat = stat.getStat();
            if (iItemStat instanceof SplitItemStat && !(splitItemStat = (SplitItemStat)iItemStat).getSplitTypes().contains(stat.getGearType())) {
                modifiedStatValue = mod.getValue() + (modifiedStatValue - mod.getValue()) * (float)splitItemStat.getSplitTypes().size();
            }
            return mod.copySetValue(modifiedStatValue);
        }
        return null;
    }

    private static double getModifiedStatValue(StatGearKey stat, StatInstance mod, ChargedProperties charge) {
        if (stat.getStat() == ItemStats.DURABILITY) {
            return (double)mod.getValue() * Math.pow(1.25, charge.getChargeValue());
        }
        if (stat.getStat() == ItemStats.ARMOR_DURABILITY) {
            return (double)mod.getValue() * Math.pow(1.1, charge.getChargeValue());
        }
        if (stat.getStat() == ItemStats.ENCHANTMENT_VALUE) {
            return (double)mod.getValue() * (1.0 + (double)charge.getChargeLevel() * Math.sqrt(charge.getChargeability() - 1.0f));
        }
        if (stat.getStat() == ItemStats.HARVEST_LEVEL) {
            return mod.getValue() + 1.0f;
        }
        if (stat.getStat() == ItemStats.HARVEST_SPEED) {
            return (double)mod.getValue() + 1.5 * (double)charge.getChargeLevel() * (double)charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.MELEE_DAMAGE) {
            return mod.getValue() + charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.MAGIC_DAMAGE) {
            return mod.getValue() + charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.RANGED_DAMAGE) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.ARMOR) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.ARMOR_TOUGHNESS) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.MAGIC_ARMOR) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        return mod.getValue();
    }

    private static boolean isSupportedModifierOp(StatInstance mod) {
        return mod.getOp() == StatInstance.Operation.AVG || mod.getOp() == StatInstance.Operation.MAX || mod.getOp() == StatInstance.Operation.ADD;
    }
}

