/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.gear.part.UpgradePart;
import net.silentchaos512.gear.util.GearData;

@Mod.EventBusSubscriber(modid="silentgear")
public final class RepairHandler {
    private RepairHandler() {
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof ICoreItem) {
            MaterialInstance material = MaterialInstance.from(event.getRight());
            PartData part = PartData.from(event.getRight());
            if (material != null) {
                RepairHandler.handleGearRepair(event, material);
            } else if (part != null && part.get() instanceof UpgradePart) {
                RepairHandler.handleUpgradeApplication(event, part);
            }
        }
    }

    private static void handleUpgradeApplication(AnvilUpdateEvent event, PartData part) {
        ItemStack result = event.getLeft().m_41777_();
        RepairHandler.applyName(event, result);
        GearData.addUpgradePart(result, part);
        GearData.recalculateStats(result, null);
        event.setOutput(result);
        event.setCost(3);
    }

    private static void handleGearRepair(AnvilUpdateEvent event, MaterialInstance material) {
        ItemStack result = event.getLeft().m_41777_();
        RepairHandler.applyName(event, result);
        float repairValue = material.getRepairValue(result, RepairContext.Type.ANVIL);
        float gearRepairEfficiency = GearData.getStat(result, ItemStats.REPAIR_EFFICIENCY);
        float anvilEfficiency = ((Double)Config.Common.repairFactorAnvil.get()).floatValue();
        float amount = repairValue * gearRepairEfficiency * anvilEfficiency;
        int materialCount = 1;
        for (float repaired = amount; materialCount < event.getRight().m_41613_() && repaired < (float)result.m_41773_(); ++materialCount, repaired += amount) {
        }
        if (amount > 0.0f) {
            result.m_220157_(-Math.round(amount * (float)materialCount), SilentGear.RANDOM_SOURCE, null);
            GearData.recalculateStats(result, null);
            event.setOutput(result);
            event.setCost(materialCount);
            event.setMaterialCost(materialCount);
        }
    }

    private static void applyName(AnvilUpdateEvent event, ItemStack stack) {
        if (!event.getName().isEmpty()) {
            stack.m_41714_((Component)Component.m_237113_((String)event.getName()));
        }
    }

    private static boolean canRepairTogether(ItemStack first, ItemStack second) {
        return first.m_41720_() == second.m_41720_() && first.m_41720_() instanceof ICoreItem && second.m_41720_() instanceof ICoreItem && GearData.getTier(first) <= GearData.getTier(second);
    }

    private static ItemStack copyCurses(ItemStack first, ItemStack second) {
        ItemStack itemstack = first.m_41777_();
        Map map = EnchantmentHelper.m_44831_((ItemStack)second);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.m_6589_() && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)itemstack) != 0) continue;
            itemstack.m_41663_(enchantment, ((Integer)entry.getValue()).intValue());
        }
        return itemstack;
    }

    private static ItemStack createGrindstoneResult(ItemStack stack, int newDamage) {
        ItemStack itemstack = stack.m_41777_();
        itemstack.m_41749_("Enchantments");
        itemstack.m_41749_("StoredEnchantments");
        if (newDamage > 0) {
            itemstack.m_41721_(newDamage);
        } else {
            itemstack.m_41749_("Damage");
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(p_217012_0_ -> ((Enchantment)p_217012_0_.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)itemstack);
        itemstack.m_41742_(0);
        if (itemstack.m_41720_() == Items.f_42690_ && map.isEmpty()) {
            itemstack = new ItemStack((ItemLike)Items.f_42517_);
            if (stack.m_41788_()) {
                itemstack.m_41714_(stack.m_41786_());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
        }
        return itemstack;
    }
}

