/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.Network;

public final class MaterialsCommand {
    private static final SuggestionProvider<CommandSourceStack> MATERIAL_ID_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82957_(MaterialManager.getValues().stream().map(IMaterial::getId), (SuggestionsBuilder)builder);
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private MaterialsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"sgear_mats");
        builder.then(Commands.m_82127_((String)"list").executes(MaterialsCommand::runList));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").then(Commands.m_82129_((String)"includeChildren", (ArgumentType)BoolArgumentType.bool()).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSourceStack>)context, (Boolean)context.getArgument("includeChildren", Boolean.class))))).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSourceStack>)context, true)));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = MaterialManager.getValues().stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)listStr), true);
        return 1;
    }

    private static int runDump(CommandContext<CommandSourceStack> context, boolean includeChildren) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SilentGear.LOGGER.info("Send material dump packet to client {}", (Object)player.m_6302_());
        ClientOutputCommandPacket message = new ClientOutputCommandPacket(ClientOutputCommandPacket.Type.MATERIALS, includeChildren);
        Network.channel.sendTo((Object)message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpClient(boolean includeChildren) {
        Player player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("MaterialsCommand#runDumpClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "material_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.m_213846_((Component)Component.m_237113_((String)("Could not create directory: " + output.getParent())));
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Pack\tName\tType\tID\tParent\tTraits\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().getString()).append("\t"));
            writer.write(builder + "\n");
            ArrayList<PartType> partTypes = new ArrayList<PartType>(PartType.getValues());
            partTypes.sort((o1, o2) -> Comparator.comparing(o -> ((PartType)o).getDisplayName(0).getString()).compare(o1, o2));
            for (PartType partType : partTypes) {
                for (IMaterial material : MaterialManager.getValues()) {
                    MaterialInstance inst;
                    if (!includeChildren && !MaterialsCommand.getParentId(material).isEmpty() || !material.allowedInPart(inst = MaterialInstance.of(material), partType)) continue;
                    writer.write(MaterialsCommand.makeTsvLine(inst, partType) + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MutableComponent fileNameText = Component.m_237113_((String)output.getAbsolutePath()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.m_213846_((Component)Component.m_237113_((String)"Wrote materials info to ").m_7220_((Component)fileNameText));
        }
    }

    private static String makeTsvLine(MaterialInstance material, PartType partType) {
        StringBuilder builder = new StringBuilder();
        MaterialsCommand.appendTsv(builder, material.get().getPackName());
        MaterialsCommand.appendTsv(builder, material.getDisplayName(partType).getString());
        int tier = material.getTier(partType);
        MaterialsCommand.appendTsv(builder, partType.getDisplayName(0).getString());
        MaterialsCommand.appendTsv(builder, material.getId().toString());
        MaterialsCommand.appendTsv(builder, MaterialsCommand.getParentId(material.get()));
        MaterialsCommand.appendTsv(builder, material.getTraits(partType).stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).getString()).collect(Collectors.joining(", ")));
        MaterialsCommand.appendTsv(builder, tier);
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = material.getStatModifiers(partType, StatGearKey.of(stat, GearType.ALL));
            MaterialsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        return builder.toString();
    }

    private static String getParentId(IMaterial material) {
        IMaterial parent = material.getParent();
        if (parent != null) {
            return parent.getId().toString();
        }
        return "";
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static Component text(String key, Object ... args) {
        return Component.m_237110_((String)("command.silentgear.parts." + key), (Object[])args);
    }
}

