/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class BlockLightingHelper {
    public static final EnumProperty<PackedData> LIGHTING = EnumProperty.m_61587_((String)"lighting", PackedData.class);
    private static final Map<BlockState, Boolean> TRANSMISSIVE = new HashMap<BlockState, Boolean>();
    private static final Map<BlockState, Integer> LUMINOSITY = new HashMap<BlockState, Integer>();

    private static void addBlockData(BlockState state) {
        TRANSMISSIVE.put(state, state.m_60631_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_));
        LUMINOSITY.put(state, state.m_60791_());
    }

    public static boolean isTransmissive(ItemStack stack) {
        return !stack.m_41619_() && BlockLightingHelper.isTransmissive(stack.m_41720_());
    }

    public static boolean isTransmissive(Item item) {
        return item instanceof BlockItem && BlockLightingHelper.isTransmissive(((BlockItem)item).m_40614_());
    }

    public static boolean isTransmissive(Block block) {
        return BlockLightingHelper.isTransmissive(block.m_49966_());
    }

    public static boolean isTransmissive(BlockState state) {
        if (!TRANSMISSIVE.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return TRANSMISSIVE.getOrDefault(state, false);
    }

    public static int getLuminosity(ItemStack stack) {
        return !stack.m_41619_() ? BlockLightingHelper.getLuminosity(stack.m_41720_()) : 0;
    }

    public static int getLuminosity(Item item) {
        return item instanceof BlockItem ? BlockLightingHelper.getLuminosity(((BlockItem)item).m_40614_()) : 0;
    }

    public static int getLuminosity(Block block) {
        return BlockLightingHelper.getLuminosity(block.m_49966_());
    }

    public static int getLuminosity(BlockState state) {
        if (!LUMINOSITY.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return LUMINOSITY.getOrDefault(state, 0);
    }

    public static BlockState setLighting(BlockState state, int value, boolean onZeroPassLight) {
        if (state.m_61138_(LIGHTING)) {
            return (BlockState)state.m_61124_(LIGHTING, (Comparable)((Object)((PackedData)((Object)state.m_61143_(LIGHTING))).setLight(value, onZeroPassLight)));
        }
        return state;
    }

    public static boolean doesLightPassThrough(BlockState state) {
        return state.m_61138_(LIGHTING) && ((PackedData)((Object)state.m_61143_(LIGHTING))).passesSkylight();
    }

    public static int getLightValue(BlockState state) {
        return state.m_61138_(LIGHTING) ? ((PackedData)((Object)state.m_61143_(LIGHTING))).getLightValue() : 0;
    }

    public static enum PackedData implements StringRepresentable
    {
        UNKNOWEN("unknowen"),
        BLOCKING("blocking"),
        PASSING("passing"),
        LVL3("emitting_3"),
        LVL6("emitting_6"),
        LVL9("emitting_9"),
        LVL12("emitting_12"),
        LVL15("emitting_15");

        private final String name;

        private PackedData(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean passesSkylight() {
            return this != UNKNOWEN && this != BLOCKING;
        }

        public int getLightValue() {
            return switch (this) {
                case LVL3 -> 3;
                case LVL6 -> 6;
                case LVL9 -> 9;
                case LVL12 -> 12;
                case LVL15 -> 15;
                default -> 0;
            };
        }

        public PackedData setLight(int value, boolean onZeroPassLight) {
            return switch (value / 3 * 3) {
                case 3 -> LVL3;
                case 6 -> LVL6;
                case 9 -> LVL9;
                case 12 -> LVL12;
                case 15 -> LVL15;
                default -> onZeroPassLight ? PASSING : BLOCKING;
            };
        }
    }
}

