/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.network;

import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRemoveChannel {
    private final int channel;

    public PacketRemoveChannel(FriendlyByteBuf buf) {
        this.channel = buf.readInt();
    }

    public PacketRemoveChannel(int channel) {
        this.channel = channel;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.channel);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer playerEntity = ctx.getSender();
            ItemStack informationItem = RedstoneInformationContainer.getRedstoneInformationItem((Player)playerEntity);
            if (informationItem.m_41720_() instanceof RedstoneInformationItem) {
                RedstoneInformationItem.removeChannel(informationItem, this.channel);
            }
        });
        ctx.setPacketHandled(true);
    }
}

