/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.devices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class VanillaCraftingDevice
implements ICraftingDevice {
    public static final ResourceLocation DEVICE_VANILLA_CRAFTING = new ResourceLocation("rftoolsstorage", "vanilla_crafting");
    private final CraftingContainer inventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player playerIn) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    private ItemStack cardStack = ItemStack.f_41583_;
    private Recipe recipe;
    private int ticks = -1;

    @Override
    public ResourceLocation getID() {
        return DEVICE_VANILLA_CRAFTING;
    }

    @Override
    public void setupCraft(@Nonnull Level world, @Nonnull ItemStack cardStack) {
        this.cardStack = cardStack;
        this.recipe = CraftingCardItem.findRecipe((Level)world, (ItemStack)cardStack, this.getRecipeType());
    }

    @Override
    public List<Ingredient> getIngredients() {
        if (this.recipe != null) {
            return this.recipe.m_7527_();
        }
        return Collections.emptyList();
    }

    @Override
    public void tick() {
        if (this.ticks > 0) {
            --this.ticks;
        }
    }

    @Override
    public boolean insertIngredients(Level world, List<ItemStack> items) {
        int i;
        if (this.recipe == null) {
            return false;
        }
        if (this.getStatus() != ICraftingDevice.Status.IDLE) {
            return false;
        }
        for (i = 0; i < items.size(); ++i) {
            this.inventory.m_6836_(i, items.get(i).m_41777_());
        }
        if (!this.recipe.m_5818_((Container)this.inventory, world)) {
            for (i = 0; i < this.inventory.m_6643_(); ++i) {
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            }
            return false;
        }
        this.ticks = 10;
        return true;
    }

    @Override
    public ItemStack getCraftingItem(Level level) {
        return BaseRecipe.assemble((Recipe)this.recipe, (CraftingContainer)this.inventory, (Level)level);
    }

    @Override
    public List<ItemStack> extractOutput(Level level) {
        if (this.getStatus() == ICraftingDevice.Status.READY) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            this.ticks = -1;
            ItemStack rc = BaseRecipe.assemble((Recipe)this.recipe, (CraftingContainer)this.inventory, (Level)level);
            if (!rc.m_41619_()) {
                result.add(rc);
            }
            for (Object item : this.recipe.m_7457_((Container)this.inventory)) {
                result.add((ItemStack)item);
            }
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ICraftingDevice.Status getStatus() {
        if (this.ticks == -1) {
            return ICraftingDevice.Status.IDLE;
        }
        if (this.ticks == 0) {
            return ICraftingDevice.Status.READY;
        }
        return ICraftingDevice.Status.BUSY;
    }

    @Override
    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44107_;
    }

    @Override
    public void read(CompoundTag tag) {
        this.cardStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("cardStack"));
        this.ticks = tag.m_128451_("ticks");
    }

    @Override
    public void write(CompoundTag tag) {
        tag.m_128405_("ticks", this.ticks);
        CompoundTag compoundNBT = new CompoundTag();
        this.cardStack.m_41739_(compoundNBT);
        tag.m_128365_("cardStack", (Tag)compoundNBT);
    }
}

