/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class CraftingGrid {
    private final CraftingGridInventory craftingGridInventory = new CraftingGridInventory();
    private final RFCraftingRecipe[] recipes = new RFCraftingRecipe[6];

    public CraftingGrid() {
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = new RFCraftingRecipe();
        }
    }

    public CraftingGridInventory getCraftingGridInventory() {
        return this.craftingGridInventory;
    }

    public RFCraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public RFCraftingRecipe getActiveRecipe() {
        RFCraftingRecipe recipe = new RFCraftingRecipe();
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
        return recipe;
    }

    public void setRecipe(int index, ItemStack[] stacks) {
        RFCraftingRecipe recipe = this.recipes[index];
        recipe.setResult(stacks[0]);
        for (int i = 0; i < 9; ++i) {
            recipe.getInventory().m_6836_(i, stacks[i + 1]);
        }
    }

    public void storeRecipe(int index) {
        RFCraftingRecipe recipe = this.getRecipe(index);
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
    }

    public void selectRecipe(int index) {
        RFCraftingRecipe recipe = this.getRecipe(index);
        this.craftingGridInventory.setStackInSlot(0, recipe.getResult());
        for (int i = 0; i < 9; ++i) {
            this.craftingGridInventory.setStackInSlot(i + 1, recipe.getInventory().m_8020_(i));
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag tagCompound = new CompoundTag();
        ListTag bufferTagList = new ListTag();
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            CompoundTag CompoundNBT = new CompoundTag();
            ItemStack stack = this.craftingGridInventory.getStackInSlot(i);
            if (!stack.m_41619_()) {
                stack.m_41739_(CompoundNBT);
            }
            bufferTagList.add((Object)CompoundNBT);
        }
        tagCompound.m_128365_("grid", (Tag)bufferTagList);
        ListTag recipeTagList = new ListTag();
        for (RFCraftingRecipe recipe : this.recipes) {
            CompoundTag CompoundNBT = new CompoundTag();
            recipe.writeToNBT(CompoundNBT);
            recipeTagList.add((Object)CompoundNBT);
        }
        tagCompound.m_128365_("recipes", (Tag)recipeTagList);
        return tagCompound;
    }

    public void readFromNBT(CompoundTag tagCompound) {
        if (tagCompound == null) {
            return;
        }
        ListTag bufferTagList = tagCompound.m_128437_("grid", 10);
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            CompoundTag CompoundNBT = bufferTagList.m_128728_(i);
            this.craftingGridInventory.setStackInSlot(i, ItemStack.m_41712_((CompoundTag)CompoundNBT));
        }
        ListTag recipeTagList = tagCompound.m_128437_("recipes", 10);
        for (int i = 0; i < recipeTagList.size(); ++i) {
            this.recipes[i] = new RFCraftingRecipe();
            CompoundTag CompoundNBT = recipeTagList.m_128728_(i);
            this.recipes[i].readFromNBT(CompoundNBT);
        }
    }
}

