/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DimensionalCellBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public static final EnumProperty<DimensionalCellTileEntity.Mode> NORTH = EnumProperty.m_61587_((String)"north", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> SOUTH = EnumProperty.m_61587_((String)"south", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> WEST = EnumProperty.m_61587_((String)"west", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> EAST = EnumProperty.m_61587_((String)"east", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> UP = EnumProperty.m_61587_((String)"up", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> DOWN = EnumProperty.m_61587_((String)"down", DimensionalCellTileEntity.Mode.class);
    private final DimensionalCellType type;
    private static final VoxelShape RENDER_SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public DimensionalCellType getType() {
        return this.type;
    }

    @Nonnull
    public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return RENDER_SHAPE;
    }

    public static DimensionalCellType getType(Block block) {
        if (block instanceof DimensionalCellBlock) {
            return ((DimensionalCellBlock)block).getType();
        }
        return DimensionalCellType.UNKNOWN;
    }

    public DimensionalCellBlock(DimensionalCellType type, BlockEntityType.BlockEntitySupplier<BlockEntity> supplier) {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60924_((state, world, pos) -> false)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).tileEntitySupplier(supplier).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powerstorage/dimensionalcell")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> {
            String energy = stack.m_41783_() == null ? "0" : String.valueOf(DimensionalCellBlock.getEnergy(stack));
            String max = String.valueOf((Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * DimensionalCellBlock.getPowerFactor(type) / (Integer)DimensionalCellConfiguration.simpleFactor.get());
            return energy + " (max " + max + " RF/FE)";
        })}));
        this.type = type;
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("BlockEntityTag");
    }

    private static int getPowerFactor(DimensionalCellType type) {
        if (type.isSimple()) {
            return 1;
        }
        return type.isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    protected boolean wrenchSneakSelect(Level world, BlockPos pos, Player player) {
        BlockEntity te;
        SmartWrenchMode currentMode;
        if (!world.f_46443_ && (currentMode = SmartWrenchItem.getCurrentMode((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) == SmartWrenchMode.MODE_SELECT && (te = world.m_7702_(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity cell = (DimensionalCellTileEntity)te;
            DimensionalCellTileEntity.dumpNetwork(player, cell);
        }
        return true;
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity cell = (DimensionalCellTileEntity)te;
            cell.toggleMode(side);
        }
        return true;
    }

    private static int getEnergy(ItemStack stack) {
        return (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"energy", (Object)0);
    }

    private static void setEnergy(ItemStack stack, int energy) {
        NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"energy", (Object)energy);
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        DimensionalCellTileEntity dimensionalCellTileEntity;
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41782_() && !world.f_46443_) {
            int networkId;
            DimensionalCellTileEntity dimensionalCellTileEntity2 = (DimensionalCellTileEntity)world.m_7702_(pos);
            if (dimensionalCellTileEntity2 != null && (networkId = dimensionalCellTileEntity2.getNetworkId()) != -1) {
                int energy = DimensionalCellBlock.getEnergy(stack);
                DimensionalCellNetwork dimensionalCellNetwork = DimensionalCellNetwork.get(world);
                DimensionalCellNetwork.Network network = dimensionalCellNetwork.getChannel(networkId);
                network.receiveEnergy(energy);
                Block block = world.m_8055_(pos).m_60734_();
                network.add(world, dimensionalCellTileEntity2.getGlobalPos(), DimensionalCellBlock.getType(block));
                dimensionalCellNetwork.save();
            }
        } else if (!stack.m_41782_() && !world.f_46443_ && (dimensionalCellTileEntity = (DimensionalCellTileEntity)world.m_7702_(pos)) != null && this.type.isCreative()) {
            dimensionalCellTileEntity.setAllOutput();
        }
        if (placer instanceof Player) {
            // empty if block
        }
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, LootContext.Builder builder) {
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        System.out.println("DimensionalCellBlock.getDrops");
        ServerLevel world = builder.m_78962_();
        Vec3 pos = (Vec3)builder.m_78982_(LootContextParams.f_81460_);
        List drops = super.m_7381_(state, builder);
        if (!world.f_46443_ && (te = world.m_7702_(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_))) instanceof DimensionalCellTileEntity && (network = ((DimensionalCellTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergySingleBlock(this.getType());
            System.out.println("getDrops: energy = " + energy);
            if (!drops.isEmpty()) {
                DimensionalCellBlock.setEnergy((ItemStack)drops.get(0), energy);
            }
        }
        return drops;
    }

    public void m_7592_(Level world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        DimensionalCellTileEntity cell;
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof DimensionalCellTileEntity && (network = (cell = (DimensionalCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.type);
            Block block = world.m_8055_(pos).m_60734_();
            network.remove(world, cell.getGlobalPos(), DimensionalCellBlock.getType(block));
            DimensionalCellNetwork.get(world).save();
            cell.setNetworkId(-1);
        }
        super.m_7592_(world, pos, explosion);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        DimensionalCellTileEntity cell;
        DimensionalCellNetwork.Network network;
        BlockEntity te;
        if (!world.f_46443_ && state.m_60734_() != newstate.m_60734_() && (te = world.m_7702_(pos)) instanceof DimensionalCellTileEntity && (network = (cell = (DimensionalCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.type);
            System.out.println("a = " + a);
            Block block = world.m_8055_(pos).m_60734_();
            network.remove(world, cell.getGlobalPos(), DimensionalCellBlock.getType(block));
            DimensionalCellNetwork.get(world).save();
        }
        super.m_6810_(state, world, pos, newstate, isMoving);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }
}

