/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketLogReady {
    private final BlockPos pos;
    private final List<String> list;
    private final String command;

    public PacketLogReady(FriendlyByteBuf buf) {
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.list = NetworkTools.readStringList((FriendlyByteBuf)buf);
    }

    public PacketLogReady(@Nullable BlockPos pos, String command, @Nonnull List<String> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<String>();
        this.list.addAll(list);
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        NetworkTools.writeStringList((FriendlyByteBuf)buf, this.list);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te;
            if (this.pos == null) {
                ProcessorContainer container = PacketLogReady.getOpenContainer();
                if (container == null) {
                    Logging.log((String)"Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            }
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ProcessorContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof ProcessorContainer) {
            return (ProcessorContainer)container;
        }
        return null;
    }
}

