/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class TupleEditor
extends AbstractParameterEditor {
    private TextField fieldX;
    private TextField fieldY;

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.fieldX = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        this.fieldY = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        constantPanel.children(new Widget[]{this.fieldX, this.fieldY});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_TUPLE);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.fieldX);
    }

    @Override
    protected ParameterValue readConstantValue() {
        Integer x = TupleEditor.parseIntSafe(this.fieldX.getText());
        Integer y = TupleEditor.parseIntSafe(this.fieldY.getText());
        return ParameterValue.constant((Object)new Tuple(x == null ? 0 : x, y == null ? 0 : y));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.fieldX.text("");
            this.fieldY.text("");
        } else {
            Tuple tuple = (Tuple)value.getValue();
            try {
                this.fieldX.text(Integer.toString(tuple.getX()));
                this.fieldY.text(Integer.toString(tuple.getY()));
            }
            catch (Exception e) {
                this.fieldX.text("");
                this.fieldY.text("");
            }
        }
    }
}

