/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardContainer;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;

public class CraftingCardItem
extends Item
implements ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/craftingcard");
    private static final CraftingContainer CRAFTING_INVENTORY = new CraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player playerIn) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
        ItemStack result = CraftingCardItem.getResult(stack);
        if (!result.m_41619_()) {
            if (result.m_41613_() > 1) {
                return result.m_41786_().getString() + "(" + result.m_41613_() + ")";
            }
            return result.m_41786_().getString();
        }
        return "<empty>";
    })});

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public CraftingCardItem() {
        super(RFToolsBase.setup.defaultProperties().m_41499_(0).m_41487_(1));
    }

    @Nullable
    private static Recipe findRecipeInternal(Level world, CraftingContainer inv, RecipeType<?> type) {
        for (Recipe r : world.m_7465_().m_44051_()) {
            if (r == null || !type.equals((Object)r.m_6671_()) || !r.m_5818_((Container)inv, world)) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public static Recipe findRecipe(Level world, ItemStack craftingCard, RecipeType<?> type) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                CRAFTING_INVENTORY.m_6836_(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        return CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, type);
    }

    public static void testRecipe(Level world, ItemStack craftingCard) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                CRAFTING_INVENTORY.m_6836_(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        Recipe recipe = CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, RecipeType.f_44107_);
        if (recipe != null) {
            ItemStack stack = BaseRecipe.assemble((Recipe)recipe, (CraftingContainer)CRAFTING_INVENTORY, (Level)world);
            stacks.set(20, (Object)stack);
        } else {
            stacks.set(20, (Object)ItemStack.f_41583_);
        }
        CraftingCardItem.putStacksInItem(craftingCard, stacks);
    }

    public static ItemStackList getStacksFromItem(ItemStack craftingCard) {
        CompoundTag tagCompound = craftingCard.m_41784_();
        ItemStackList stacks = ItemStackList.create((int)21);
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundTag nbtTagCompound = bufferTagList.m_128728_(i);
            stacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)nbtTagCompound));
        }
        return stacks;
    }

    public static void putStacksInItem(ItemStack craftingCard, ItemStackList stacks) {
        CompoundTag tagCompound = craftingCard.m_41784_();
        ListTag bufferTagList = new ListTag();
        for (ItemStack stack : stacks) {
            CompoundTag nbtTagCompound = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(nbtTagCompound);
            }
            bufferTagList.add((Object)nbtTagCompound);
        }
        tagCompound.m_128365_("Items", (Tag)bufferTagList);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, list, flagIn);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!world.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @Nonnull
                public Component m_5446_() {
                    return ComponentFactory.literal((String)"Crafting Card");
                }

                public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                    CraftingCardContainer container = new CraftingCardContainer(id, player.m_20183_(), player);
                    container.setupInventories(null, playerInventory);
                    return container;
                }
            });
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return ItemStack.f_41583_;
        }
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        CompoundTag nbtTagCompound = bufferTagList.m_128728_(20);
        return ItemStack.m_41712_((CompoundTag)nbtTagCompound);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return false;
        }
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundTag nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.m_41712_((CompoundTag)(nbtTagCompound = bufferTagList.m_128728_(i)))).m_41619_() || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static List<Ingredient> getIngredientsGrid(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            if (i >= 20) continue;
            CompoundTag nbtTagCompound = bufferTagList.m_128728_(i);
            ItemStack s = ItemStack.m_41712_((CompoundTag)nbtTagCompound);
            if (!CraftingCardItem.isInGrid(i)) continue;
            stacks.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{s}));
        }
        return stacks;
    }

    public static List<ItemStack> getIngredientStacks(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundTag nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.m_41712_((CompoundTag)(nbtTagCompound = bufferTagList.m_128728_(i)))).m_41619_()) continue;
            stacks.add(s);
        }
        return stacks;
    }

    public static List<Ingredient> getIngredients(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        ListTag bufferTagList = tagCompound.m_128437_("Items", 10);
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundTag nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.m_41712_((CompoundTag)(nbtTagCompound = bufferTagList.m_128728_(i)))).m_41619_()) continue;
            stacks.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{s}));
        }
        return stacks;
    }
}

