/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericMemoryPack
implements PackResources {
    private final HashMap<ResourceLocation, Supplier<? extends InputStream>> data = new HashMap();
    private final JsonObject metaData;
    private final PackType allowedType;
    private final String id;

    protected GenericMemoryPack(PackType type, String id, JsonObject meta) {
        this.metaData = meta;
        this.allowedType = type;
        this.id = id;
    }

    private boolean isTypeAllowed(PackType type) {
        return this.allowedType.equals((Object)type);
    }

    public void putData(PackType type, ResourceLocation location, Supplier<? extends InputStream> supplier) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.put(location, supplier);
    }

    public void putJson(PackType type, ResourceLocation location, JsonElement json) {
        this.putData(type, location, () -> new ByteArrayInputStream(Constants.GSON.toJson(json).getBytes(StandardCharsets.UTF_8)));
    }

    @NotNull
    public InputStream m_5542_(@NotNull String file) throws IOException {
        if (file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        throw new FileNotFoundException(file);
    }

    @NotNull
    public InputStream m_8031_(@NotNull PackType type, @NotNull ResourceLocation location) throws IOException {
        if (this.m_7211_(type, location)) {
            return this.data.get(location).get();
        }
        throw new FileNotFoundException(location.toString());
    }

    @NotNull
    public Collection<ResourceLocation> m_214146_(@NotNull PackType type, @NotNull String namespace, @NotNull String path, @NotNull Predicate<ResourceLocation> predicate) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptyList();
        }
        return this.data.keySet().stream().filter(location -> location.m_135827_().equals(namespace)).filter(location -> location.m_135815_().startsWith(path)).filter(location -> predicate.test(GenericMemoryPack.createPath(namespace, location.m_135815_().substring(Math.max(location.m_135815_().lastIndexOf(47), 0))))).collect(Collectors.toList());
    }

    private static ResourceLocation createPath(String namespace, String input) {
        return ResourceLocation.m_135820_((String)(namespace + ":" + input));
    }

    public boolean m_7211_(@NotNull PackType type, @NotNull ResourceLocation location) {
        return this.isTypeAllowed(type) && this.data.containsKey(location);
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType type) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptySet();
        }
        return this.data.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> serializer) {
        if (!serializer.m_7991_().equals("pack")) {
            return null;
        }
        return (T)serializer.m_6322_(this.metaData);
    }

    @NotNull
    public String m_8017_() {
        return this.id;
    }

    public void close() {
        for (Supplier<? extends InputStream> value : this.data.values()) {
            try {
                value.get().close();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to close input stream", (Throwable)e);
            }
        }
    }
}

