/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.bounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;

public final class UniformedNumberCodecs {
    public static final Codec<UniformFloat> FLOAT_CODEC = UniformedNumberCodecs.getFloatCodec();
    public static final Codec<UniformInt> INT_CODEC = UniformedNumberCodecs.getIntCodec();

    private UniformedNumberCodecs() {
    }

    private static Codec<UniformFloat> getFloatCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(UniformFloat::m_142735_), (App)Codec.FLOAT.fieldOf("max").forGetter(UniformFloat::m_142734_)).apply((Applicative)instance, UniformFloat::m_146605_));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.m_142734_() < uniformFloat.m_142735_()) {
                return DataResult.error((String)("Max must be at least min, min: " + uniformFloat.m_142735_() + ", max: " + uniformFloat.m_142734_()));
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }

    public static Codec<UniformInt> getIntCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(UniformInt::m_142739_), (App)Codec.INT.fieldOf("max").forGetter(UniformInt::m_142737_)).apply((Applicative)instance, UniformInt::m_146622_));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.m_142737_() < uniformInt.m_142739_()) {
                return DataResult.error((String)("Max must be at least min, min: " + uniformInt.m_142739_() + ", max: " + uniformInt.m_142737_()));
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<UniformInt> rangedUniformIntCodec(int min, int max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)min, (int)max).fieldOf("min").forGetter(UniformInt::m_142739_), (App)Codec.intRange((int)min, (int)max).fieldOf("max").forGetter(UniformInt::m_142737_)).apply((Applicative)instance, UniformInt::m_146622_));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.m_142737_() < uniformInt.m_142739_()) {
                return DataResult.error((String)("Max must be at least min, min: " + uniformInt.m_142739_() + ", max: " + uniformInt.m_142737_()));
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<UniformFloat> rangedUniformFloatCodec(float min, float max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)min, (float)max).fieldOf("min").forGetter(UniformFloat::m_142735_), (App)Codec.floatRange((float)min, (float)max).fieldOf("max").forGetter(UniformFloat::m_142734_)).apply((Applicative)instance, UniformFloat::m_146605_));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.m_142734_() < uniformFloat.m_142735_()) {
                return DataResult.error((String)("Max must be at least min, min: " + uniformFloat.m_142735_() + ", max: " + uniformFloat.m_142734_()));
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }
}

