/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.entities.MerchantOfferAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.items.MapItemAccessor;
import com.telepathicgrunt.repurposedstructures.utils.AsyncLocator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MerchantMapUpdating {
    private MerchantMapUpdating() {
    }

    public static void invalidateMap(AbstractVillager merchant, ItemStack mapStack) {
        mapStack.m_41714_((Component)Component.m_237115_((String)"item.minecraft.map"));
        merchant.m_6616_().stream().filter(offer -> offer.m_45368_() == mapStack).findFirst().ifPresentOrElse(offer -> MerchantMapUpdating.removeOffer(merchant, offer), () -> RepurposedStructures.LOGGER.warn("Failed to find merchant offer for map"));
    }

    public static void removeOffer(AbstractVillager merchant, MerchantOffer offer) {
        ((MerchantOfferAccessor)offer).setMaxUses(0);
        offer.m_45381_();
    }

    public static void handleLocationFound(ServerLevel level, AbstractVillager merchant, ItemStack mapStack, String displayName, MapDecoration.Type destinationType, BlockPos pos) {
        if (pos == null) {
            MerchantMapUpdating.invalidateMap(merchant, mapStack);
        } else {
            MerchantMapUpdating.updateMap(mapStack, level, pos, 2, destinationType, displayName);
        }
        Player player = merchant.m_7962_();
        if (player instanceof ServerPlayer) {
            int n;
            ServerPlayer tradingPlayer = (ServerPlayer)player;
            int n2 = tradingPlayer.f_36096_.f_38840_;
            MerchantOffers merchantOffers = merchant.m_6616_();
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                n = villager.m_7141_().m_35576_();
            } else {
                n = 1;
            }
            tradingPlayer.m_7662_(n2, merchantOffers, n, merchant.m_7809_(), merchant.m_7826_(), merchant.m_7862_());
        }
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, MapDecoration.Type destinationType, int maxUses, int villagerXp, TagKey<Structure> destination, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, destination, merchant.m_20183_(), searchRadius, true).thenOnServerThread(pos -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pos)));
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, MapDecoration.Type destinationType, int maxUses, int villagerXp, HolderSet<Structure> structureSet, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, structureSet, merchant.m_20183_(), searchRadius, true).thenOnServerThread(pair -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, (BlockPos)pair.getFirst())));
    }

    private static MerchantOffer updateMapAsyncInternal(Entity trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof AbstractVillager) {
            AbstractVillager merchant = (AbstractVillager)trader;
            ItemStack mapStack = MerchantMapUpdating.createEmptyMap();
            task.apply((ServerLevel)trader.f_19853_, merchant, mapStack);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, emeraldCost), new ItemStack((ItemLike)Items.f_42522_), mapStack, maxUses, villagerXp, 0.2f);
        }
        return null;
    }

    public static ItemStack createEmptyMap() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42573_);
        stack.m_41714_((Component)Component.m_237115_((String)"menu.working"));
        return stack;
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, String displayName) {
        MapItemAccessor.callCreateAndStoreSavedData(mapStack, (Level)level, pos.m_123341_(), pos.m_123343_(), scale, true, true, (ResourceKey<Level>)level.m_46472_());
        MapItem.m_42850_((ServerLevel)level, (ItemStack)mapStack);
        MapItemSavedData.m_77925_((ItemStack)mapStack, (BlockPos)pos, (String)"+", (MapDecoration.Type)destinationType);
        if (displayName != null) {
            mapStack.m_41714_((Component)Component.m_237115_((String)displayName));
        }
    }

    public static interface MapUpdateTask {
        public void apply(ServerLevel var1, AbstractVillager var2, ItemStack var3);
    }
}

