/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.items.ToggleableItem;
import reliquary.items.util.IScrollableItem;
import reliquary.reference.Settings;
import reliquary.util.NBTHelper;
import reliquary.util.RandHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class PyromancerStaffItem
extends ToggleableItem
implements IScrollableItem {
    private static final int EFFECT_COOLDOWN = 2;
    private static final int INVENTORY_SEARCH_COOLDOWN = 10;

    public PyromancerStaffItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).m_130940_(ChatFormatting.RED);
    }

    public void m_6883_(ItemStack stack, Level world, Entity e, int i, boolean f) {
        Player player;
        block6: {
            block5: {
                if (!(e instanceof Player)) break block5;
                player = (Player)e;
                if (world.m_46467_() % 2L == 0L) break block6;
            }
            return;
        }
        this.doFireballAbsorbEffect(stack, player);
        if (!this.isEnabled(stack)) {
            this.doExtinguishEffect(player);
        } else {
            this.scanForFireChargeAndBlazePowder(stack, player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        AtomicInteger charges = new AtomicInteger(0);
        AtomicInteger blaze = new AtomicInteger(0);
        this.iterateItems(staff, tag -> {
            String itemName = tag.m_128461_("Name");
            int quantity = tag.m_128451_("Quantity");
            if (itemName.equals(RegistryHelper.getItemRegistryName(Items.f_42593_))) {
                blaze.set(quantity);
            } else if (itemName.equals(RegistryHelper.getItemRegistryName(Items.f_42613_))) {
                charges.set(quantity);
            }
        }, () -> false);
        tooltipBuilder.charge(this, ".tooltip.charges", charges.get());
        tooltipBuilder.charge(this, ".tooltip.blaze", blaze.get());
        tooltipBuilder.description(this, ".tooltip.controls", new Object[0]);
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(Items.f_42593_.m_7626_(new ItemStack((ItemLike)Items.f_42593_)).getString() + " & " + Items.f_42613_.m_7626_(new ItemStack((ItemLike)Items.f_42613_)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int m_8105_(ItemStack par1ItemStack) {
        return 11;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public Mode getMode(ItemStack stack) {
        return NBTHelper.getEnumConstant(stack, "mode", Mode::valueOf).orElse(Mode.BLAZE);
    }

    private void setMode(ItemStack stack, Mode mode) {
        NBTHelper.putString("mode", stack, mode.m_7912_());
    }

    private void cycleMode(ItemStack stack, boolean next) {
        this.setMode(stack, next ? this.getMode(stack).next() : this.getMode(stack).previous());
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            super.m_7203_(world, player, hand);
        } else if (this.getMode(stack) == Mode.BLAZE) {
            player.m_6674_(hand);
            this.shootBlazeFireball(player, stack);
        } else if (this.getMode(stack) == Mode.FIRE_CHARGE) {
            player.m_6674_(hand);
            Vec3 lookVec = player.m_20154_();
            this.shootGhastFireball(player, stack, lookVec);
        } else {
            player.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void shootGhastFireball(Player player, ItemStack stack, Vec3 lookVec) {
        if (this.removeItemFromInternalStorage(stack, Items.f_42613_, this.getFireChargeCost(), player.f_19853_.f_46443_, player)) {
            player.f_19853_.m_5898_(player, 1016, player.m_20183_(), 0);
            LargeFireball fireball = new LargeFireball(player.f_19853_, (LivingEntity)player, lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_, 1);
            fireball.f_36813_ = lookVec.f_82479_ / 3.0;
            fireball.f_36814_ = lookVec.f_82480_ / 3.0;
            fireball.f_36815_ = lookVec.f_82481_ / 3.0;
            fireball.m_6034_(fireball.m_20185_() + lookVec.f_82479_, player.m_20186_() + (double)player.m_20192_(), fireball.m_20189_() + lookVec.f_82481_);
            player.f_19853_.m_7967_((Entity)fireball);
        }
    }

    private void shootBlazeFireball(Player player, ItemStack stack) {
        Vec3 lookVec = player.m_20154_();
        if (this.removeItemFromInternalStorage(stack, Items.f_42593_, this.getBlazePowderCost(), player.f_19853_.f_46443_, player)) {
            player.f_19853_.m_5898_(player, 1018, player.m_20183_(), 0);
            SmallFireball fireball = new SmallFireball(player.f_19853_, (LivingEntity)player, lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_);
            fireball.f_36813_ = lookVec.f_82479_ / 3.0;
            fireball.f_36814_ = lookVec.f_82480_ / 3.0;
            fireball.f_36815_ = lookVec.f_82481_ / 3.0;
            fireball.m_6034_(fireball.m_20185_() + lookVec.f_82479_, player.m_20186_() + (double)player.m_20192_(), fireball.m_20189_() + lookVec.f_82481_);
            player.f_19853_.m_7967_((Entity)fireball);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        Player player;
        HitResult rayTraceResult;
        if (!(entity instanceof Player)) {
            return;
        }
        if (this.getMode(stack) == Mode.ERUPTION && this.getInternalStorageItemCount(stack, Items.f_42593_) > 0 && (rayTraceResult = (player = (Player)entity).m_19907_(12.0, 1.0f, true)).m_6662_() == HitResult.Type.BLOCK) {
            --count;
            count = this.m_8105_(stack) - count;
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
            this.doEruptionAuxEffects(player, blockRayTraceResult.m_82425_().m_123341_(), blockRayTraceResult.m_82425_().m_123342_(), blockRayTraceResult.m_82425_().m_123343_());
            if (count % 10 == 0 && this.removeItemFromInternalStorage(stack, Items.f_42593_, this.getBlazePowderCost(), player.f_19853_.f_46443_, player)) {
                this.doEruptionEffect(player, blockRayTraceResult.m_82425_().m_123341_(), blockRayTraceResult.m_82425_().m_123342_(), blockRayTraceResult.m_82425_().m_123343_());
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (this.getMode(stack) == Mode.FLINT_AND_STEEL) {
            return Items.f_42409_.m_6225_(new UseOnContext(context.m_43725_(), player, context.m_43724_(), new ItemStack((ItemLike)Items.f_42409_), context.m_43718_()));
        }
        return InteractionResult.PASS;
    }

    private void doEruptionAuxEffects(Player player, int soundX, int soundY, int soundZ) {
        player.f_19853_.m_7785_((double)soundX + 0.5, (double)soundY + 0.5, (double)soundZ + 0.5, SoundEvents.f_11923_, SoundSource.NEUTRAL, 0.2f, 0.03f + 0.07f * player.f_19853_.f_46441_.m_188501_(), false);
        this.spawnLavaParticles(player, soundX, soundY, soundZ);
        this.spawnFlameParticles(player, soundX, soundY, soundZ);
    }

    private void spawnFlameParticles(Player player, int soundX, int soundY, int soundZ) {
        double randZ;
        double randX;
        int particleCount;
        for (particleCount = 0; particleCount < 6; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, randX, (double)soundY + 1.0, randZ, player.f_19853_.f_46441_.m_188583_() * 0.2, player.f_19853_.f_46441_.m_188583_() * 0.2, player.f_19853_.f_46441_.m_188583_() * 0.2);
        }
        for (particleCount = 0; particleCount < 8; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, randX, (double)soundY + 1.0, randZ, player.f_19853_.f_46441_.m_188583_() * 0.2, player.f_19853_.f_46441_.m_188583_() * 0.2, player.f_19853_.f_46441_.m_188583_() * 0.2);
        }
    }

    private void spawnLavaParticles(Player player, int soundX, int soundY, int soundZ) {
        double randZ;
        double randX;
        int particleCount;
        for (particleCount = 0; particleCount < 2; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
        for (particleCount = 0; particleCount < 4; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.f_19853_.f_46441_.m_188501_() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
    }

    private void doEruptionEffect(Player player, int x, int y, int z) {
        double lowerX = (double)x - 5.0 + 0.5;
        double lowerZ = (double)z - 5.0 + 0.5;
        double upperX = (double)x + 5.0 + 0.5;
        double upperY = (double)y + 5.0;
        double upperZ = (double)z + 5.0 + 0.5;
        List entities = player.f_19853_.m_45976_(Mob.class, new AABB(lowerX, (double)y, lowerZ, upperX, upperY, upperZ));
        entities.stream().filter(e -> !e.m_7306_((Entity)player)).forEach(e -> {
            e.m_20254_(40);
            if (!e.m_5825_()) {
                e.m_6469_(DamageSource.m_19344_((Player)player), 4.0f);
            }
        });
    }

    private void scanForFireChargeAndBlazePowder(ItemStack staff, Player player) {
        if (player.f_19853_.m_46467_() % 10L != 0L) {
            return;
        }
        int currentFireChargeCount = this.getInternalStorageItemCount(staff, Items.f_42613_);
        this.consumeAndCharge(player, this.getFireChargeLimit() - currentFireChargeCount, this.getFireChargeWorth(), Items.f_42613_, 16, (int chargeToAdd) -> this.addItemToInternalStorage(staff, Items.f_42613_, chargeToAdd));
        int currentBlazePowderCount = this.getInternalStorageItemCount(staff, Items.f_42593_);
        this.consumeAndCharge(player, this.getBlazePowderLimit() - currentBlazePowderCount, this.getBlazePowderWorth(), Items.f_42593_, 16, (int chargeToAdd) -> this.addItemToInternalStorage(staff, Items.f_42593_, chargeToAdd));
    }

    private int getFireChargeWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeWorth.get();
    }

    private int getFireChargeCost() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeCost.get();
    }

    private int getFireChargeLimit() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeLimit.get();
    }

    private int getBlazePowderWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderWorth.get();
    }

    private int getBlazePowderCost() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderCost.get();
    }

    private int getBlazePowderLimit() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderLimit.get();
    }

    private int getBlazeAbsorbWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazeAbsorbWorth.get();
    }

    private int getGhastAbsorbWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.ghastAbsorbWorth.get();
    }

    private void doExtinguishEffect(Player player) {
        if (player.m_6060_()) {
            player.m_20095_();
        }
        BlockPos.m_121940_((BlockPos)player.m_20183_().m_7918_(-3, -3, -3), (BlockPos)player.m_20183_().m_7918_(3, 3, 3)).forEach(pos -> {
            Block block = player.f_19853_.m_8055_(pos).m_60734_();
            if (block instanceof BaseFireBlock) {
                player.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                player.f_19853_.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.8f);
            }
        });
    }

    private void doFireballAbsorbEffect(ItemStack stack, Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        this.absorbGhastFireballs(stack, player);
        this.absorbBlazeFireballs(stack, player);
    }

    private void absorbBlazeFireballs(ItemStack stack, Player player) {
        List blazeFireballs = player.f_19853_.m_45976_(SmallFireball.class, player.m_20191_().m_82400_(3.0));
        for (SmallFireball fireball : blazeFireballs) {
            if (fireball.m_37282_() == player) continue;
            if (this.hasSpaceForItem(stack, Items.f_42593_, this.getBlazePowderLimit())) {
                for (int particles = 0; particles < 4; ++particles) {
                    player.f_19853_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_(), 0.0, 1.0, 1.0);
                }
                player.f_19853_.m_7785_(fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.8f, false);
                this.addItemToInternalStorage(stack, Items.f_42593_, this.getBlazeAbsorbWorth());
            }
            fireball.m_146870_();
        }
    }

    private void absorbGhastFireballs(ItemStack stack, Player player) {
        List ghastFireballs = player.f_19853_.m_45976_(LargeFireball.class, player.m_20191_().m_82400_(4.0));
        for (LargeFireball fireball : ghastFireballs) {
            if (fireball.m_37282_() == player) continue;
            if (this.hasSpaceForItem(stack, Items.f_42613_, this.getFireChargeLimit())) {
                this.addItemToInternalStorage(stack, Items.f_42613_, this.getGhastAbsorbWorth());
                player.f_19853_.m_7785_(fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.8f, false);
            }
            fireball.m_146870_();
        }
    }

    public static enum Mode implements StringRepresentable
    {
        BLAZE,
        FIRE_CHARGE,
        ERUPTION,
        FLINT_AND_STEEL;

        private static final Mode[] VALUES;

        public String m_7912_() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

