/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.Reliquary;
import reliquary.util.TooltipBuilder;

public class ItemBase
extends Item {
    private final Supplier<Boolean> isDisabled;

    public ItemBase() {
        this(new Item.Properties(), () -> false);
    }

    public ItemBase(Supplier<Boolean> isDisabled) {
        this(new Item.Properties(), isDisabled);
    }

    public ItemBase(Item.Properties properties) {
        this(properties, () -> false);
    }

    public ItemBase(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties.m_41491_(Reliquary.ITEM_GROUP));
        this.isDisabled = isDisabled;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (Boolean.TRUE.equals(this.isDisabled.get())) {
            return;
        }
        super.m_6787_(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder tooltipBuilder = TooltipBuilder.of(tooltip).itemTooltip(this);
        if (this.hasMoreInformation(stack)) {
            tooltipBuilder.showMoreInfo();
            if (Screen.m_96638_()) {
                this.addMoreInformation(stack, world, tooltipBuilder);
            }
        }
    }

    protected boolean hasMoreInformation(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable Level world, TooltipBuilder tooltipBuilder) {
    }

    public MutableComponent getName(ItemStack stack) {
        return Component.m_237115_((String)this.m_5671_(stack));
    }
}

