/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.crafting.FragmentRecipeHelper;

public class FragmentToSpawnEggRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapelessRecipe recipeDelegate;

    public FragmentToSpawnEggRecipe(ShapelessRecipe recipeDelegate) {
        super(recipeDelegate.m_6423_(), recipeDelegate.m_6076_(), recipeDelegate.m_8043_(), recipeDelegate.m_7527_());
        this.recipeDelegate = recipeDelegate;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return super.m_5818_(inv, worldIn) && FragmentRecipeHelper.hasOnlyOneFragmentType(inv);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        return FragmentRecipeHelper.getRegistryName(inv).map(FragmentRecipeHelper::getSpawnEggStack).orElse(new ItemStack((ItemLike)FragmentRecipeHelper.FALL_BACK_SPAWN_EGG));
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FragmentToSpawnEggRecipe> {
        public FragmentToSpawnEggRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new FragmentToSpawnEggRecipe((ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(recipeId, json));
        }

        @Nullable
        public FragmentToSpawnEggRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new FragmentToSpawnEggRecipe((ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(recipeId, buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, FragmentToSpawnEggRecipe recipe) {
            RecipeSerializer.f_44077_.m_6178_(buffer, (Recipe)recipe.recipeDelegate);
        }
    }
}

