/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.config.CoreClientConfig;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.item.ILeftClickHandlerItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.TridentItemCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.client.renderer.FluxTridentBEWLR;
import cofh.redstonearsenal.entity.ThrownFluxTrident;
import cofh.redstonearsenal.item.IFluxItem;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;

public class FluxTridentItem
extends TridentItemCoFH
implements IMultiModeFluxItem,
ILeftClickHandlerItem {
    public static final double PLUNGE_RANGE = 2.0;
    public static final double PLUNGE_SPEED = 3.0;
    protected final float damage;
    protected final float attackSpeed;
    protected final float addedRange;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxTridentItem(Tier tier, int attackDamageIn, float attackSpeedIn, float rangeIn, Item.Properties builder, int energy, int xfer) {
        super(tier, builder);
        this.damage = (float)attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
        this.addedRange = rangeIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("throwing"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_().equals(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public FluxTridentItem(Tier tier, int enchantability, int attackDamageIn, float attackSpeedIn, float reachIn, Item.Properties builder, int energy, int xfer) {
        this(tier, attackDamageIn, attackSpeedIn, reachIn, builder, energy, xfer);
        this.enchantability = enchantability;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        LivingEntity living;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21209_() && (living.m_20096_() || living.m_5842_() && living.m_20184_().m_82556_() < (double)0.09f)) {
            FluxTridentItem.stopSpinAttack(living);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasEnergy(stack, false) && !player.m_21209_() && (EnchantmentHelper.m_44932_((ItemStack)stack) <= 0 || player.m_20070_())) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int remainingDuration) {
        if (entity instanceof Player) {
            int riptideLevel;
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - remainingDuration;
            if (i >= 10 && ((riptideLevel = EnchantmentHelper.m_44932_((ItemStack)stack)) <= 0 || player.m_20070_())) {
                if (!world.f_46443_ && this.useEnergy(stack, false, player.f_36077_.f_35937_) && riptideLevel == 0) {
                    ThrownFluxTrident tridentEntity = new ThrownFluxTrident(world, (LivingEntity)player, stack);
                    tridentEntity.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                    if (player.f_36077_.f_35937_) {
                        tridentEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_((Entity)tridentEntity);
                    world.m_6269_(null, (Entity)tridentEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.f_36077_.f_35937_) {
                        player.f_36093_.m_36057_(stack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptideLevel > 0) {
                    float degToRad = (float)Math.PI / 180;
                    float xRotRad = player.f_19858_ * degToRad;
                    float yRotRad = player.f_19857_ * degToRad;
                    float xPush = -MathHelper.sin((float)yRotRad) * MathHelper.cos((float)xRotRad);
                    float yPush = -MathHelper.sin((float)xRotRad);
                    float zPush = MathHelper.cos((float)yRotRad) * MathHelper.cos((float)xRotRad);
                    float riptideMult = (1.0f + (float)riptideLevel) * 0.75f / MathHelper.sqrt((float)(xPush * xPush + yPush * yPush + zPush * zPush));
                    player.m_5997_((double)(xPush * riptideMult), (double)(yPush * riptideMult), (double)(zPush * riptideMult));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999, 0.0));
                    }
                    SoundEvent soundevent = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    world.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_21209_() && player.f_19789_ > 3.0f) {
            player.f_19789_ = 0.0f;
            player.m_20256_(player.m_20184_().m_82490_(-5.0));
        }
        return false;
    }

    public boolean startPlunge(LivingEntity living) {
        if (!FluxTridentItem.canStartPlunging(living)) {
            return false;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            player.m_36321_();
            player.f_36077_.f_35935_ = false;
            player.m_204079_(200);
        }
        Vec3 motion = FluxTridentItem.getPlungeVector(living.m_20154_(), this.getPlungeSpeed());
        living.m_5997_(motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
        return true;
    }

    public static boolean canStartPlunging(LivingEntity living) {
        if (living.m_20096_() || living.m_21209_()) {
            return false;
        }
        ClipContext context = new ClipContext(living.m_20182_(), living.m_20182_().m_82520_(0.0, -3.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living);
        return living.f_19853_.m_45547_(context).m_6662_().equals((Object)HitResult.Type.MISS);
    }

    public boolean plungeAttack(Level world, LivingEntity attacker, ItemStack stack) {
        if (attacker.f_19789_ <= (float)attacker.m_6056_() || !this.isEmpowered(stack) || !this.useEnergy(stack, true, (Entity)attacker)) {
            return false;
        }
        float range = this.getPlungeRange(attacker.f_19789_);
        if (world.f_46443_) {
            world.m_7106_((ParticleOptions)new CylindricalParticleOptions((ParticleType)CoreParticles.BLAST_WAVE.get(), range * 2.0f, range * 3.0f, 1.5f), attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 0.0, 0.0, 0.0);
            return true;
        }
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44958_, (ItemStack)stack) > 0 && world.m_45527_(attacker.m_20183_()) && world instanceof ServerLevel && world.m_46470_()) {
            attacker.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get(), 40, 0, false, false));
            Utils.spawnLightningBolt((Level)world, (BlockPos)attacker.m_20183_(), (Entity)attacker);
        }
        double r2 = range * range;
        boolean hit = false;
        for (Entity target : world.m_6249_((Entity)attacker, attacker.m_20191_().m_82377_((double)range, 1.0, (double)range), EntitySelector.f_20406_)) {
            if (!(attacker.m_20280_(target) <= r2)) continue;
            hit |= target.m_6469_(IFluxItem.fluxDirectDamage(attacker), this.getPlungeAttackDamage(attacker, stack));
        }
        if (hit) {
            world.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 10.0f, 1.0f);
        } else {
            world.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12515_, SoundSource.PLAYERS, 3.0f, 1.0f);
        }
        return hit;
    }

    public static void stopSpinAttack(LivingEntity living) {
        if (living.m_21209_()) {
            living.f_20938_ = 0;
            AABB noVolume = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            living.m_21071_(noVolume, noVolume);
        }
    }

    public static Vec3 getPlungeVector(Vec3 lookVector, double magnitude) {
        double x = lookVector.m_7096_();
        double y = lookVector.m_7098_();
        double z = lookVector.m_7094_();
        double compSqr = lookVector.m_82556_() * 0.75;
        if (x < (double)1.0E-4f && z < (double)1.0E-4f) {
            return new Vec3(0.0, -magnitude, 0.0);
        }
        if (compSqr > y * y || y > 0.0) {
            double comp = Math.sqrt(compSqr);
            double horzSum = Math.abs(x) + Math.abs(z);
            return new Vec3(x / horzSum * comp, -comp, z / horzSum * comp).m_82490_(magnitude);
        }
        return lookVector.m_82490_(magnitude);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(Constants.UUID_WEAPON_RANGE, "Weapon modifier", (double)this.getAddedAttackRange(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getPlungeAttackDamage(LivingEntity living, ItemStack stack) {
        return this.hasEnergy(stack, true) && living.f_19789_ > (float)living.m_6056_() ? 2.5f * MathHelper.sqrt((float)living.f_19789_) : 0.0f;
    }

    public float getPlungeRange(float height) {
        return -20.0f / (7.0f + height) + 4.5f;
    }

    public double getPlungeSpeed() {
        return 3.0;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected float getAddedAttackRange(ItemStack stack) {
        return this.addedRange;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return FluxTridentBEWLR.INSTANCE;
            }
        });
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    public void onLeftClick(Player player, ItemStack stack) {
        if (this.isEmpowered(stack) && this.hasEnergy(stack, true)) {
            this.startPlunge((LivingEntity)player);
        }
    }
}

