/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.capability.CapabilityArchery;
import cofh.core.config.CoreClientConfig;
import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.FluxArrow;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxQuiverItem
extends ItemCoFH
implements IMultiModeFluxItem {
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;
    protected int energyPerUse = 500;
    protected int energyPerUseEmpowered = 2000;

    public FluxQuiverItem(int enchantability, Item.Properties builder, int energy, int xfer) {
        this(enchantability, builder, energy, xfer, 1.0f);
    }

    public FluxQuiverItem(int enchantability, Item.Properties builder, int energy, int xfer, float energyUseMod) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.energyPerUse = (int)((float)this.energyPerUse * energyUseMod);
        this.energyPerUseEmpowered = (int)((float)this.energyPerUseEmpowered * energyUseMod);
        this.setEnchantability(enchantability);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IMultiModeFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxQuiverItemWrapper(stack, this);
    }

    @Override
    public int getEnergyPerUse(boolean empowered) {
        return empowered ? this.energyPerUseEmpowered : this.energyPerUse;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxQuiverItemWrapper
    extends EnergyContainerItemWrapper
    implements IArcheryAmmoItem {
        private final LazyOptional<IArcheryAmmoItem> holder;
        final ItemStack quiverItem;

        FluxQuiverItemWrapper(ItemStack quiverItemContainer, IEnergyContainerItem item) {
            super(quiverItemContainer, item, item.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.quiverItem = quiverItemContainer;
        }

        public void onArrowLoosed(Player shooter) {
            FluxQuiverItem.this.useEnergy(this.quiverItem, FluxQuiverItem.this.isEmpowered(this.quiverItem), shooter != null && shooter.f_36077_.f_35937_);
        }

        public AbstractArrow createArrowEntity(Level world, Player shooter) {
            FluxArrow arrow = new FluxArrow(world, (LivingEntity)shooter);
            arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            if (FluxQuiverItem.this.isEmpowered(this.quiverItem)) {
                ItemStack weapon;
                ItemStack itemStack = weapon = shooter.m_21205_().m_41619_() ? shooter.m_21206_() : shooter.m_21205_();
                if (!weapon.m_41619_()) {
                    if (weapon.m_41720_() instanceof CrossbowItem) {
                        arrow.setExplodeArrow(true);
                        arrow.m_36781_(8.0);
                    } else {
                        arrow.m_20242_(true);
                    }
                }
            }
            return arrow;
        }

        public boolean isEmpty(Player shooter) {
            return !FluxQuiverItem.this.hasEnergy(this.quiverItem, FluxQuiverItem.this.isEmpowered(this.quiverItem));
        }

        public boolean isInfinite(ItemStack bow, Player shooter) {
            return shooter != null && shooter.f_36077_.f_35937_ || Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)bow) > 0;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.AMMO_ITEM_CAPABILITY) {
                return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

