/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RSASounds;
import cofh.redstonearsenal.item.FluxElytraItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxElytraControllerItem
extends Item
implements ICoFHItem,
IMultiModeItem {
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public FluxElytraControllerItem(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), (stack, world, entity, seed) -> this.isEmpowered(stack) ? 1.0f : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.isEmpowered(stack)) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.1").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.0").m_130940_(ChatFormatting.GRAY));
        }
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
    }

    public boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) > 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        Item item = chest.m_41720_();
        if (item instanceof FluxElytraItem) {
            FluxElytraItem elytra = (FluxElytraItem)item;
            elytra.setMode(chest, this.getMode(stack));
            if (elytra.boost(chest, (LivingEntity)player)) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        Item item = chest.m_41720_();
        if (item instanceof FluxElytraItem) {
            FluxElytraItem elytra = (FluxElytraItem)item;
            elytra.setMode(chest, this.getMode(stack));
            if (this.isEmpowered(stack)) {
                player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)RSASounds.SOUND_EMPOWER.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            } else {
                player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)RSASounds.SOUND_QUELL.get(), SoundSource.PLAYERS, 0.2f, 0.6f);
            }
        } else {
            this.setMode(stack, this.isEmpowered(stack) ? 0 : 1);
        }
    }

    public FluxElytraControllerItem setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public FluxElytraControllerItem setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public FluxElytraControllerItem setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

