/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.core.multiblock.rectangular;

import net.gigabit101.rebornstorage.core.multiblock.MultiblockControllerBase;
import net.gigabit101.rebornstorage.core.multiblock.MultiblockValidationException;
import net.gigabit101.rebornstorage.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(Level world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.m_123341_() - minimumCoord.m_123341_() + 1;
        int deltaY = maximumCoord.m_123342_() - minimumCoord.m_123342_() + 1;
        int deltaZ = maximumCoord.m_123343_() - minimumCoord.m_123343_() + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.m_123341_(); x <= maximumCoord.m_123341_(); ++x) {
            for (int y = minimumCoord.m_123342_(); y <= maximumCoord.m_123342_(); ++y) {
                for (int z = minimumCoord.m_123343_(); z <= maximumCoord.m_123343_(); ++z) {
                    RectangularMultiblockTileEntityBase part;
                    BlockEntity te = this.worldObj.m_7702_(new BlockPos(x, y, z));
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.m_123341_()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.m_123342_()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.m_123343_()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.m_123341_()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.m_123342_()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.m_123343_()) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.m_123342_()) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.m_123342_()) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

