/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.roguelogix.phosphophyllite.repack.org.joml.AABBi;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4fc;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicLight;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.common.DynamicLightManager;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl.GLBuffer;
import net.roguelogix.quartz.internal.gl.GLCore;
import net.roguelogix.quartz.internal.gl.GLMainProgram;
import net.roguelogix.quartz.internal.gl.GLRenderPass;
import org.lwjgl.opengl.ARBBaseInstance;
import org.lwjgl.opengl.ARBDrawIndirect;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBMultiDrawIndirect;
import org.lwjgl.opengl.ARBVertexAttribBinding;
import org.lwjgl.opengl.GL32C;

@NonnullDefault
public class GLDrawBatch
implements DrawBatch {
    private static final Matrix4fc IDENTITY_MATRIX = new Matrix4f();
    private static final Matrix4f SCRATCH_NORMAL_MATRIX = new Matrix4f();
    private final GLBuffer instanceDataBuffer = new GLBuffer(false);
    private final GLBuffer dynamicMatrixBuffer = new GLBuffer(false);
    private final DynamicMatrixManager dynamicMatrixManager = new DynamicMatrixManager(this.dynamicMatrixBuffer);
    private final DynamicMatrix IDENTITY_DYNAMIC_MATRIX = this.dynamicMatrixManager.createMatrix((matrix, nanoSinceLastFrame, partialTicks, playerBlock, playerPartialBlock) -> matrix.write(IDENTITY_MATRIX), null);
    private final GLBuffer dynamicLightBuffer = new GLBuffer(false);
    private final DynamicLightManager lightManager = new DynamicLightManager(this.dynamicLightBuffer);
    private final DynamicLightManager.Light ZERO_LEVEL_LIGHT = this.lightManager.createLight((light, blockAndTintGetter) -> light.write((byte)0, (byte)0, (byte)0));
    private final int VAO;
    private final int dynamicMatrixTexture;
    private final int dynamicLightTexture;
    private final Object2ObjectMap<InternalMesh, MeshInstanceManager> instanceManagers = new Object2ObjectOpenHashMap();
    private final ObjectOpenHashSet<MeshInstanceManager> instanceBatches = new ObjectOpenHashSet();
    private final Object2ObjectMap<GLRenderPass, ObjectArrayList<MeshInstanceManager.DrawComponent>> opaqueDrawComponents = new Object2ObjectArrayMap();
    private final Object2ObjectMap<GLRenderPass, ObjectArrayList<MeshInstanceManager.DrawComponent>> cutoutDrawComponents = new Object2ObjectArrayMap();
    private final GLBuffer indirectDrawBuffer = GLCore.DRAW_INDIRECT ? new GLBuffer(false) : null;
    private final Object2ObjectMap<GLRenderPass, IndirectDrawBlock> opaqueIndirectInfo = new Object2ObjectArrayMap();
    private final Object2ObjectMap<GLRenderPass, IndirectDrawBlock> cutoutIndirectInfo = new Object2ObjectArrayMap();
    private boolean indirectDrawInfoDirty = false;
    private boolean rebuildIndirectBlocks = false;
    private AABBi cullAABB = null;
    private Vector4f cullVector = new Vector4f();
    private Vector4f cullVectorMin = new Vector4f();
    private Vector4f cullVectorMax = new Vector4f();
    private boolean enabled = true;
    private boolean culled = false;

    public GLDrawBatch() {
        int VAO = GL32C.glGenVertexArrays();
        B3DStateHelper.bindVertexArray(VAO);
        B3DStateHelper.bindElementBuffer(GLCore.INSTANCE.elementBuffer.handle());
        GL32C.glEnableVertexAttribArray((int)0);
        GL32C.glEnableVertexAttribArray((int)1);
        GL32C.glEnableVertexAttribArray((int)2);
        GL32C.glEnableVertexAttribArray((int)3);
        GL32C.glEnableVertexAttribArray((int)4);
        GL32C.glEnableVertexAttribArray((int)5);
        GL32C.glEnableVertexAttribArray((int)6);
        GL32C.glEnableVertexAttribArray((int)8);
        GL32C.glEnableVertexAttribArray((int)9);
        GL32C.glEnableVertexAttribArray((int)10);
        GL32C.glEnableVertexAttribArray((int)11);
        GL32C.glEnableVertexAttribArray((int)12);
        GL32C.glEnableVertexAttribArray((int)13);
        GL32C.glEnableVertexAttribArray((int)14);
        GL32C.glEnableVertexAttribArray((int)15);
        if (GLCore.ATTRIB_BINDING) {
            ARBVertexAttribBinding.glBindVertexBuffer((int)0, (int)QuartzCore.INSTANCE.meshManager.vertexBuffer.as(GLBuffer.class).handle(), (long)0L, (int)32);
            ARBVertexAttribBinding.glVertexAttribBinding((int)0, (int)0);
            ARBVertexAttribBinding.glVertexAttribBinding((int)1, (int)0);
            ARBVertexAttribBinding.glVertexAttribBinding((int)2, (int)0);
            ARBVertexAttribBinding.glVertexAttribBinding((int)3, (int)0);
            ARBVertexAttribBinding.glVertexAttribFormat((int)0, (int)3, (int)5126, (boolean)false, (int)0);
            ARBVertexAttribBinding.glVertexAttribIFormat((int)1, (int)1, (int)5124, (int)12);
            ARBVertexAttribBinding.glVertexAttribFormat((int)2, (int)2, (int)5126, (boolean)false, (int)16);
            ARBVertexAttribBinding.glVertexAttribIFormat((int)3, (int)2, (int)5124, (int)24);
            if (GLCore.BASE_INSTANCE || GLCore.DRAW_INDIRECT) {
                ARBVertexAttribBinding.glBindVertexBuffer((int)1, (int)this.instanceDataBuffer.handle(), (long)0L, (int)256);
            }
            ARBVertexAttribBinding.glVertexBindingDivisor((int)1, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)4, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)5, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)6, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)8, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)9, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)10, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)11, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)12, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)13, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)14, (int)1);
            ARBVertexAttribBinding.glVertexAttribBinding((int)15, (int)1);
            offset = 0;
            ARBVertexAttribBinding.glVertexAttribIFormat((int)4, (int)3, (int)5124, (int)offset);
            ARBVertexAttribBinding.glVertexAttribIFormat((int)5, (int)1, (int)5124, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribIFormat((int)6, (int)1, (int)5124, (int)(offset += 4));
            ARBVertexAttribBinding.glVertexAttribFormat((int)8, (int)4, (int)5126, (boolean)false, (int)(offset += 4));
            ARBVertexAttribBinding.glVertexAttribFormat((int)9, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)10, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)11, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)12, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)13, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)14, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            ARBVertexAttribBinding.glVertexAttribFormat((int)15, (int)4, (int)5126, (boolean)false, (int)(offset += 16));
            offset += 16;
        } else {
            B3DStateHelper.bindArrayBuffer(QuartzCore.INSTANCE.meshManager.vertexBuffer.as(GLBuffer.class).handle());
            GL32C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
            GL32C.glVertexAttribIPointer((int)1, (int)1, (int)5124, (int)32, (long)12L);
            GL32C.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)32, (long)16L);
            GL32C.glVertexAttribIPointer((int)3, (int)2, (int)5124, (int)32, (long)24L);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)4, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)5, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)6, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)8, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)9, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)10, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)11, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)12, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)13, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)14, (int)1);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)15, (int)1);
            if (GLCore.BASE_INSTANCE || GLCore.DRAW_INDIRECT) {
                B3DStateHelper.bindArrayBuffer(this.instanceDataBuffer.handle());
                offset = 0;
                GL32C.glVertexAttribIPointer((int)4, (int)3, (int)5124, (int)256, (long)offset);
                GL32C.glVertexAttribIPointer((int)5, (int)1, (int)5124, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribIPointer((int)6, (int)1, (int)5124, (int)256, (long)(offset += 4));
                GL32C.glVertexAttribPointer((int)8, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 4));
                GL32C.glVertexAttribPointer((int)9, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)10, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)11, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)12, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)13, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)14, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                GL32C.glVertexAttribPointer((int)15, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                offset += 16;
            }
        }
        GL32C.glBindVertexArray((int)0);
        int dynamicMatrixTexture = GL32C.glGenTextures();
        GL32C.glBindTexture((int)35882, (int)dynamicMatrixTexture);
        GL32C.glTexBuffer((int)35882, (int)34836, (int)this.dynamicMatrixBuffer.handle());
        int dynamicLightTexture = GL32C.glGenTextures();
        GL32C.glBindTexture((int)35882, (int)dynamicLightTexture);
        GL32C.glTexBuffer((int)35882, (int)33336, (int)this.dynamicLightBuffer.handle());
        GL32C.glBindTexture((int)35882, (int)0);
        QuartzCore.CLEANER.register(this, () -> QuartzCore.deletionQueue.enqueue(() -> {
            GL32C.glDeleteTextures((int)dynamicLightTexture);
            GL32C.glDeleteTextures((int)dynamicMatrixTexture);
            GL32C.glDeleteVertexArrays((int)VAO);
        }, new Event[0]));
        this.VAO = VAO;
        this.dynamicMatrixTexture = dynamicMatrixTexture;
        this.dynamicLightTexture = dynamicLightTexture;
    }

    @Override
    @Nullable
    public DrawBatch.InstanceBatch createInstanceBatch(Mesh quartzMesh) {
        if (!(quartzMesh instanceof InternalMesh)) {
            return null;
        }
        InternalMesh mesh = (InternalMesh)quartzMesh;
        MeshInstanceManager instanceManager = new MeshInstanceManager(mesh, false);
        MeshInstanceManager.InstanceBatch instanceBatch = new MeshInstanceManager.InstanceBatch(instanceManager);
        this.instanceBatches.add((Object)instanceManager);
        return instanceBatch;
    }

    @Override
    @Nullable
    public DrawBatch.Instance createInstance(Vector3ic position, Mesh quartzMesh, @Nullable DynamicMatrix quartzDynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable DynamicLight quartzLight, @Nullable DynamicLight.Type lightType) {
        DynamicLightManager.Light light;
        DynamicMatrixManager.Matrix dynamicMatrix;
        if (!(quartzMesh instanceof InternalMesh)) {
            return null;
        }
        InternalMesh mesh = (InternalMesh)quartzMesh;
        if (quartzDynamicMatrix == null) {
            quartzDynamicMatrix = this.IDENTITY_DYNAMIC_MATRIX;
        }
        if (!(quartzDynamicMatrix instanceof DynamicMatrixManager.Matrix) || !this.dynamicMatrixManager.owns(dynamicMatrix = (DynamicMatrixManager.Matrix)quartzDynamicMatrix)) {
            return null;
        }
        if (quartzLight == null) {
            if (lightType == null) {
                lightType = DynamicLight.Type.SMOOTH;
            }
            quartzLight = QuartzCore.INSTANCE.lightEngine.createLightForPos(position, this.lightManager, lightType);
        }
        if (!(quartzLight instanceof DynamicLightManager.Light) || !this.lightManager.owns(light = (DynamicLightManager.Light)quartzLight)) {
            return null;
        }
        MeshInstanceManager instanceManager = (MeshInstanceManager)this.instanceManagers.computeIfAbsent((Object)mesh, m -> new MeshInstanceManager((InternalMesh)m, true));
        if (staticMatrix == null) {
            staticMatrix = IDENTITY_MATRIX;
        }
        return instanceManager.createInstance(position, dynamicMatrix, staticMatrix, light);
    }

    @Override
    public DynamicMatrix createDynamicMatrix(@Nullable DynamicMatrix parentTransform, @Nullable DynamicMatrix.UpdateFunc updateFunc) {
        return this.dynamicMatrixManager.createMatrix(updateFunc, parentTransform);
    }

    @Override
    public DynamicLight createLight(Vector3ic lightPosition, DynamicLight.Type lightType) {
        return QuartzCore.INSTANCE.lightEngine.createLightForPos(lightPosition, this.lightManager, lightType);
    }

    @Override
    public void setCullAABB(AABBi aabb) {
        this.cullAABB = aabb;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEmpty() {
        return this.instanceManagers.isEmpty() && this.instanceBatches.isEmpty();
    }

    void updateAndCull(DrawInfo drawInfo) {
        this.dynamicMatrixManager.updateAll(drawInfo.deltaNano, drawInfo.partialTicks, drawInfo.playerPosition, drawInfo.playerSubBlock);
        if (this.cullAABB != null) {
            this.cullVectorMin.set(2.0f);
            this.cullVectorMax.set(-2.0f);
            for (int i = 0; i < 8; ++i) {
                this.cullVector.set((float)(((i & 1) == 0 ? this.cullAABB.maxX : this.cullAABB.minX) - drawInfo.playerPosition.x), (float)(((i & 2) == 0 ? this.cullAABB.maxY : this.cullAABB.minY) - drawInfo.playerPosition.y), (float)(((i & 4) == 0 ? this.cullAABB.maxZ : this.cullAABB.minZ) - drawInfo.playerPosition.z), 1.0f);
                this.cullVector.sub(drawInfo.playerSubBlock.x, drawInfo.playerSubBlock.y, drawInfo.playerSubBlock.z, 0.0f);
                this.cullVector.mul((Matrix4fc)drawInfo.projectionMatrix);
                this.cullVector.div(this.cullVector.w);
                this.cullVectorMin.min((Vector4fc)this.cullVector);
                this.cullVectorMax.max((Vector4fc)this.cullVector);
            }
            this.culled = this.cullVectorMin.x > 1.0f || this.cullVectorMax.x < -1.0f || this.cullVectorMin.y > 1.0f || this.cullVectorMax.y < -1.0f || this.cullVectorMin.z > 1.0f || this.cullVectorMax.z < -1.0f;
        } else {
            this.culled = false;
        }
        if (this.culled) {
            return;
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        this.lightManager.updateAll((BlockAndTintGetter)Minecraft.m_91087_().f_91073_);
        this.dynamicMatrixBuffer.flush();
        this.dynamicLightBuffer.flush();
        this.instanceDataBuffer.flush();
        this.updateIndirectInfo();
    }

    private void updateIndirectInfo() {
        if (!GLCore.DRAW_INDIRECT || !this.indirectDrawInfoDirty) {
            return;
        }
        this.indirectDrawInfoDirty = false;
        if (this.rebuildIndirectBlocks) {
            this.rebuildIndirectBlocks = false;
            this.opaqueIndirectInfo.forEach((glRenderPass, drawBlock) -> this.indirectDrawBuffer.free(drawBlock.drawInfoAlloc));
            this.cutoutIndirectInfo.forEach((glRenderPass, drawBlock) -> this.indirectDrawBuffer.free(drawBlock.drawInfoAlloc));
            this.opaqueIndirectInfo.clear();
            this.cutoutIndirectInfo.clear();
            this.opaqueDrawComponents.forEach((glRenderPass, drawComponents) -> this.opaqueIndirectInfo.put(glRenderPass, (Object)new IndirectDrawBlock((ObjectArrayList<MeshInstanceManager.DrawComponent>)drawComponents, this.indirectDrawBuffer, GLCore.MULTIDRAW_INDIRECT)));
            this.cutoutDrawComponents.forEach((glRenderPass, drawComponents) -> this.cutoutIndirectInfo.put(glRenderPass, (Object)new IndirectDrawBlock((ObjectArrayList<MeshInstanceManager.DrawComponent>)drawComponents, this.indirectDrawBuffer, GLCore.MULTIDRAW_INDIRECT)));
        } else {
            this.opaqueIndirectInfo.values().forEach(IndirectDrawBlock::updateDrawInfo);
            this.cutoutIndirectInfo.values().forEach(IndirectDrawBlock::updateDrawInfo);
        }
        this.indirectDrawBuffer.dirtyAll();
        this.indirectDrawBuffer.flush();
    }

    void drawOpaque() {
        if (!this.enabled || this.culled || this.opaqueDrawComponents.isEmpty()) {
            return;
        }
        if (!GLMainProgram.SSBO) {
            GL32C.glActiveTexture((int)33986);
            GL32C.glBindTexture((int)35882, (int)this.dynamicMatrixTexture);
            GL32C.glActiveTexture((int)33987);
            GL32C.glBindTexture((int)35882, (int)this.dynamicLightTexture);
        } else {
            GL32C.glBindBufferBase((int)37074, (int)0, (int)this.dynamicMatrixBuffer.handle());
            GL32C.glBindBufferBase((int)37074, (int)1, (int)this.dynamicLightBuffer.handle());
        }
        if (!GLCore.BASE_INSTANCE && !GLCore.DRAW_INDIRECT) {
            B3DStateHelper.bindArrayBuffer(this.instanceDataBuffer.handle());
        }
        GLMainProgram program = GLCore.INSTANCE.mainProgram;
        GL32C.glActiveTexture((int)33984);
        GL32C.glBindVertexArray((int)this.VAO);
        if (GLCore.DRAW_INDIRECT) {
            GL32C.glBindBuffer((int)36671, (int)this.indirectDrawBuffer.handle());
            this.opaqueIndirectInfo.forEach((renderPass, drawBlock) -> {
                program.setupRenderPass((GLRenderPass)renderPass);
                drawBlock.draw();
            });
        } else {
            for (Map.Entry entry : this.opaqueDrawComponents.entrySet()) {
                program.setupRenderPass((GLRenderPass)entry.getKey());
                ObjectArrayList drawComponents = (ObjectArrayList)entry.getValue();
                for (int i = 0; i < drawComponents.size(); ++i) {
                    ((MeshInstanceManager.DrawComponent)drawComponents.get(i)).draw();
                }
            }
        }
    }

    void drawCutout() {
        if (!this.enabled || this.culled || this.cutoutDrawComponents.isEmpty()) {
            return;
        }
        if (!GLMainProgram.SSBO) {
            GL32C.glActiveTexture((int)33986);
            GL32C.glBindTexture((int)35882, (int)this.dynamicMatrixTexture);
            GL32C.glActiveTexture((int)33987);
            GL32C.glBindTexture((int)35882, (int)this.dynamicLightTexture);
        } else {
            GL32C.glBindBufferBase((int)37074, (int)0, (int)this.dynamicMatrixBuffer.handle());
            GL32C.glBindBufferBase((int)37074, (int)1, (int)this.dynamicLightBuffer.handle());
        }
        if (!GLCore.BASE_INSTANCE && !GLCore.DRAW_INDIRECT) {
            B3DStateHelper.bindArrayBuffer(this.instanceDataBuffer.handle());
        }
        GLMainProgram program = GLCore.INSTANCE.mainProgram;
        GL32C.glActiveTexture((int)33984);
        GL32C.glBindVertexArray((int)this.VAO);
        if (GLCore.DRAW_INDIRECT) {
            GL32C.glBindBuffer((int)36671, (int)this.indirectDrawBuffer.handle());
            this.cutoutIndirectInfo.forEach((renderPass, drawBlock) -> {
                program.setupRenderPass((GLRenderPass)renderPass);
                drawBlock.draw();
            });
        } else {
            for (Map.Entry entry : this.cutoutDrawComponents.entrySet()) {
                program.setupRenderPass((GLRenderPass)entry.getKey());
                ObjectArrayList drawComponents = (ObjectArrayList)entry.getValue();
                for (int i = 0; i < drawComponents.size(); ++i) {
                    ((MeshInstanceManager.DrawComponent)drawComponents.get(i)).draw();
                }
            }
        }
    }

    private class MeshInstanceManager {
        private final boolean autoDelete;
        private InternalMesh staticMesh;
        private InternalMesh.Manager.TrackedMesh trackedMesh;
        private final Consumer<InternalMesh.Manager.TrackedMesh> meshBuildCallback;
        private final ObjectArrayList<DrawComponent> components = new ObjectArrayList();
        private Buffer.Allocation instanceDataAlloc;
        private int instanceDataOffset;
        private final ObjectArrayList<Instance.Location> liveInstances = new ObjectArrayList();
        private int instanceCount = 0;

        private MeshInstanceManager(InternalMesh mesh, boolean autoDelete) {
            this.autoDelete = autoDelete;
            WeakReference<MeshInstanceManager> ref = new WeakReference<MeshInstanceManager>(this);
            this.meshBuildCallback = ignored -> {
                MeshInstanceManager manager = (MeshInstanceManager)ref.get();
                if (manager != null) {
                    manager.onRebuild();
                }
            };
            this.instanceDataAlloc = GLDrawBatch.this.instanceDataBuffer.alloc(256);
            this.instanceDataAlloc.addReallocCallback(alloc -> {
                MeshInstanceManager manager = (MeshInstanceManager)ref.get();
                if (manager != null) {
                    manager.instanceDataOffset = alloc.offset();
                }
            });
            this.updateMesh(mesh);
        }

        public void updateMesh(Mesh quartzMesh) {
            if (!(quartzMesh instanceof InternalMesh)) {
                return;
            }
            InternalMesh mesh = (InternalMesh)quartzMesh;
            if (this.trackedMesh != null) {
                this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
            }
            this.staticMesh = mesh;
            this.trackedMesh = QuartzCore.INSTANCE.meshManager.getMeshInfo(mesh);
            if (this.trackedMesh == null) {
                throw new IllegalArgumentException("Unable to find mesh in mesh registry");
            }
            this.onRebuild();
            this.trackedMesh.addBuildCallback(this.meshBuildCallback);
        }

        private void onRebuild() {
            for (int i = 0; i < this.components.size(); ++i) {
                GLRenderPass renderPass;
                DrawComponent component = (DrawComponent)this.components.get(i);
                Object2ObjectMap<GLRenderPass, ObjectArrayList<DrawComponent>> componentMap = renderPass.ALPHA_DISCARD ? GLDrawBatch.this.cutoutDrawComponents : GLDrawBatch.this.opaqueDrawComponents;
                ObjectArrayList drawComponents = (ObjectArrayList)componentMap.get((Object)(renderPass = component.renderPass));
                if (drawComponents == null) {
                    component.drawIndex = -1;
                    continue;
                }
                if (component.drawIndex != -1) {
                    DrawComponent removed = (DrawComponent)drawComponents.pop();
                    if (component.drawIndex < drawComponents.size()) {
                        removed.drawIndex = component.drawIndex;
                        drawComponents.set(component.drawIndex, (Object)removed);
                    }
                    component.drawIndex = -1;
                }
                if (!drawComponents.isEmpty()) continue;
                componentMap.remove((Object)renderPass);
            }
            this.components.clear();
            for (RenderType renderType : this.trackedMesh.usedRenderTypes()) {
                InternalMesh.Manager.TrackedMesh.Component component = this.trackedMesh.renderTypeComponent(renderType);
                if (component == null) continue;
                DrawComponent drawComponent = new DrawComponent(renderType, component);
                this.components.add((Object)drawComponent);
            }
            GLDrawBatch.this.rebuildIndirectBlocks = true;
            GLDrawBatch.this.indirectDrawInfoDirty = true;
        }

        @Nullable
        public DrawBatch.Instance createInstance(Vector3ic position, @Nullable DynamicMatrix quartzDynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable DynamicLight quartzLight, @Nullable DynamicLight.Type lightType) {
            DynamicLightManager.Light light;
            DynamicMatrixManager.Matrix dynamicMatrix;
            if (quartzDynamicMatrix == null) {
                quartzDynamicMatrix = GLDrawBatch.this.IDENTITY_DYNAMIC_MATRIX;
            }
            if (!(quartzDynamicMatrix instanceof DynamicMatrixManager.Matrix) || !GLDrawBatch.this.dynamicMatrixManager.owns(dynamicMatrix = (DynamicMatrixManager.Matrix)quartzDynamicMatrix)) {
                return null;
            }
            if (quartzLight == null) {
                if (lightType == null) {
                    lightType = DynamicLight.Type.SMOOTH;
                }
                quartzLight = QuartzCore.INSTANCE.lightEngine.createLightForPos(position, GLDrawBatch.this.lightManager, lightType);
            }
            if (!(quartzLight instanceof DynamicLightManager.Light) || !GLDrawBatch.this.lightManager.owns(light = (DynamicLightManager.Light)quartzLight)) {
                return null;
            }
            if (staticMatrix == null) {
                staticMatrix = IDENTITY_MATRIX;
            }
            return this.createInstance(position, dynamicMatrix, staticMatrix, light);
        }

        Instance createInstance(Vector3ic worldPosition, DynamicMatrixManager.Matrix dynamicMatrix, Matrix4fc staticMatrix, DynamicLightManager.Light dynamicLight) {
            if (this.instanceDataAlloc.size() < (this.instanceCount + 1) * 256) {
                this.instanceDataAlloc = GLDrawBatch.this.instanceDataBuffer.realloc(this.instanceDataAlloc, this.instanceDataAlloc.size() * 2, 256);
            }
            ByteBuffer byteBuf = this.instanceDataAlloc.buffer();
            int baseOffset = this.instanceCount * 256;
            worldPosition.get(baseOffset + 0, byteBuf);
            byteBuf.putInt(baseOffset + 16, dynamicMatrix.id());
            byteBuf.putInt(baseOffset + 20, dynamicLight.id());
            staticMatrix.get(baseOffset + 24, byteBuf);
            staticMatrix.normal(SCRATCH_NORMAL_MATRIX).get(baseOffset + 88, byteBuf);
            GLDrawBatch.this.instanceDataBuffer.dirtyAll();
            Instance instance = new Instance(this.instanceCount++, dynamicMatrix, dynamicLight);
            this.liveInstances.add((Object)instance.location);
            GLDrawBatch.this.indirectDrawInfoDirty = true;
            return instance;
        }

        void removeInstance(Instance.Location instance) {
            if (instance.location == -1) {
                return;
            }
            --this.instanceCount;
            Instance.Location endInstance = (Instance.Location)this.liveInstances.pop();
            if (instance != endInstance) {
                this.instanceDataAlloc.copy(endInstance.location * 256, instance.location * 256, 256);
                this.liveInstances.set(instance.location, (Object)endInstance);
                endInstance.location = instance.location;
            }
            instance.location = -1;
            if (this.instanceCount == 0 && this.autoDelete) {
                this.delete();
            }
            GLDrawBatch.this.indirectDrawInfoDirty = true;
        }

        public void delete() {
            while (!this.liveInstances.isEmpty()) {
                this.removeInstance((Instance.Location)this.liveInstances.peek(0));
            }
            for (int i = 0; i < this.components.size(); ++i) {
                GLRenderPass renderPass;
                DrawComponent component = (DrawComponent)this.components.get(i);
                Object2ObjectMap<GLRenderPass, ObjectArrayList<DrawComponent>> componentMap = renderPass.ALPHA_DISCARD ? GLDrawBatch.this.cutoutDrawComponents : GLDrawBatch.this.opaqueDrawComponents;
                ObjectArrayList drawComponents = (ObjectArrayList)componentMap.get((Object)(renderPass = component.renderPass));
                if (drawComponents == null) {
                    component.drawIndex = -1;
                    continue;
                }
                if (component.drawIndex != -1) {
                    DrawComponent removed = (DrawComponent)drawComponents.pop();
                    if (component.drawIndex < drawComponents.size()) {
                        removed.drawIndex = component.drawIndex;
                        drawComponents.set(component.drawIndex, (Object)removed);
                    }
                    component.drawIndex = -1;
                }
                if (!drawComponents.isEmpty()) continue;
                componentMap.remove((Object)renderPass);
            }
            this.components.clear();
            GLDrawBatch.this.instanceManagers.remove((Object)this.staticMesh, (Object)this);
            GLDrawBatch.this.instanceBatches.remove((Object)this);
            GLDrawBatch.this.rebuildIndirectBlocks = true;
            GLDrawBatch.this.indirectDrawInfoDirty = true;
            this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
        }

        private class DrawComponent {
            private final GLRenderPass renderPass;
            private final boolean QUAD;
            public final int GL_MODE;
            private int drawIndex;
            private final int baseVertex;
            private final int elementCount;

            private DrawComponent(RenderType renderType, InternalMesh.Manager.TrackedMesh.Component component) {
                this.renderPass = GLRenderPass.renderPassForRenderType(renderType);
                this.QUAD = this.renderPass.QUAD;
                this.GL_MODE = this.renderPass.GL_MODE;
                this.baseVertex = component.vertexOffset();
                int elementCountTemp = component.vertexCount();
                if (this.QUAD) {
                    elementCountTemp *= 6;
                    GLCore.INSTANCE.ensureElementBufferLength((elementCountTemp /= 4) / 6);
                }
                this.elementCount = elementCountTemp;
                ObjectArrayList drawComponents = (ObjectArrayList)(this.renderPass.ALPHA_DISCARD ? GLDrawBatch.this.cutoutDrawComponents : GLDrawBatch.this.opaqueDrawComponents).computeIfAbsent((Object)this.renderPass, e -> new ObjectArrayList());
                this.drawIndex = drawComponents.size();
                drawComponents.add((Object)this);
            }

            private void draw() {
                if (!GLCore.BASE_INSTANCE) {
                    if (GLCore.ATTRIB_BINDING) {
                        ARBVertexAttribBinding.glBindVertexBuffer((int)1, (int)GLDrawBatch.this.instanceDataBuffer.handle(), (long)MeshInstanceManager.this.instanceDataOffset, (int)256);
                    } else {
                        int offset = MeshInstanceManager.this.instanceDataOffset;
                        GL32C.glVertexAttribIPointer((int)4, (int)3, (int)5124, (int)256, (long)offset);
                        GL32C.glVertexAttribIPointer((int)5, (int)1, (int)5124, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribIPointer((int)6, (int)1, (int)5124, (int)256, (long)(offset += 4));
                        GL32C.glVertexAttribPointer((int)8, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 4));
                        GL32C.glVertexAttribPointer((int)9, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)10, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)11, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)12, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)13, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)14, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        GL32C.glVertexAttribPointer((int)15, (int)4, (int)5126, (boolean)false, (int)256, (long)(offset += 16));
                        offset += 16;
                    }
                    if (this.QUAD) {
                        GL32C.glDrawElementsInstancedBaseVertex((int)4, (int)this.elementCount, (int)5125, (long)0L, (int)MeshInstanceManager.this.instanceCount, (int)this.baseVertex);
                    } else {
                        GL32C.glDrawArraysInstanced((int)this.GL_MODE, (int)this.baseVertex, (int)this.elementCount, (int)MeshInstanceManager.this.instanceCount);
                    }
                } else if (this.QUAD) {
                    ARBBaseInstance.glDrawElementsInstancedBaseVertexBaseInstance((int)4, (int)this.elementCount, (int)5125, (long)0L, (int)MeshInstanceManager.this.instanceCount, (int)this.baseVertex, (int)(MeshInstanceManager.this.instanceDataOffset / 256));
                } else {
                    ARBBaseInstance.glDrawArraysInstancedBaseInstance((int)this.GL_MODE, (int)this.baseVertex, (int)this.elementCount, (int)MeshInstanceManager.this.instanceCount, (int)(MeshInstanceManager.this.instanceDataOffset / 256));
                }
            }

            private IndirectDrawInfo indirectInfo() {
                return new IndirectDrawInfo(this.elementCount, MeshInstanceManager.this.instanceCount, this.baseVertex, MeshInstanceManager.this.instanceDataOffset / 256);
            }

            private record IndirectDrawInfo(int elementCount, int instanceCount, int baseVertex, int baseInstance) {
            }
        }

        private class Instance
        implements DrawBatch.Instance {
            private final Location location;
            private InstanceBatch batch;
            private DynamicMatrixManager.Matrix dynamicMatrix;
            private DynamicLightManager.Light dynamicLight;

            private Instance(int initialLocation, DynamicMatrixManager.Matrix dynamicMatrix, DynamicLightManager.Light dynamicLight) {
                MeshInstanceManager manager = MeshInstanceManager.this;
                Location location = new Location(initialLocation);
                QuartzCore.CLEANER.register(this, () -> QuartzCore.deletionQueue.enqueue(() -> manager.removeInstance(location), new Event[0]));
                this.location = location;
                this.dynamicMatrix = dynamicMatrix;
                this.dynamicLight = dynamicLight;
            }

            @Override
            public void updateDynamicMatrix(@Nullable DynamicMatrix newDynamicMatrix) {
                DynamicMatrixManager.Matrix dynamicMatrix;
                if (this.dynamicMatrix == newDynamicMatrix) {
                    return;
                }
                if (newDynamicMatrix == null) {
                    newDynamicMatrix = GLDrawBatch.this.IDENTITY_DYNAMIC_MATRIX;
                }
                if (newDynamicMatrix instanceof DynamicMatrixManager.Matrix && GLDrawBatch.this.dynamicMatrixManager.owns(dynamicMatrix = (DynamicMatrixManager.Matrix)newDynamicMatrix)) {
                    this.dynamicMatrix = dynamicMatrix;
                    int offset = this.location.location * 256 + 16;
                    MeshInstanceManager.this.instanceDataAlloc.buffer().putInt(offset, dynamicMatrix.id());
                    MeshInstanceManager.this.instanceDataAlloc.dirtyRange(offset, 4);
                }
            }

            @Override
            public void updateStaticMatrix(@Nullable Matrix4fc newStaticMatrix) {
                if (newStaticMatrix == null) {
                    newStaticMatrix = IDENTITY_MATRIX;
                }
                int transformOffset = this.location.location * 256 + 24;
                int normalOffset = this.location.location * 256 + 88;
                newStaticMatrix.get(transformOffset, MeshInstanceManager.this.instanceDataAlloc.buffer());
                newStaticMatrix.normal(SCRATCH_NORMAL_MATRIX).get(normalOffset, MeshInstanceManager.this.instanceDataAlloc.buffer());
                MeshInstanceManager.this.instanceDataAlloc.dirtyRange(transformOffset, 128);
            }

            @Override
            public void updateDynamicLight(@Nullable DynamicLight newDynamicLight) {
                DynamicLightManager.Light dynamicLight;
                if (this.dynamicLight == newDynamicLight) {
                    return;
                }
                if (newDynamicLight == null) {
                    newDynamicLight = GLDrawBatch.this.ZERO_LEVEL_LIGHT;
                }
                if (newDynamicLight instanceof DynamicLightManager.Light && GLDrawBatch.this.lightManager.owns(dynamicLight = (DynamicLightManager.Light)newDynamicLight)) {
                    this.dynamicLight = dynamicLight;
                    int newLightID = dynamicLight.id();
                    int offset = this.location.location * 256 + 20;
                    MeshInstanceManager.this.instanceDataAlloc.buffer().putInt(offset, newLightID);
                    MeshInstanceManager.this.instanceDataAlloc.dirtyRange(offset, 4);
                }
            }

            @Override
            public void delete() {
                MeshInstanceManager.this.removeInstance(this.location);
            }

            private static class Location {
                private int location;

                private Location(int location) {
                    this.location = location;
                }
            }
        }

        private static class InstanceBatch
        implements DrawBatch.InstanceBatch {
            private final MeshInstanceManager instanceManager;

            public InstanceBatch(MeshInstanceManager instanceManager) {
                this.instanceManager = instanceManager;
                QuartzCore.CLEANER.register(this, instanceManager::delete);
            }

            @Override
            public void updateMesh(Mesh mesh) {
                this.instanceManager.updateMesh(mesh);
            }

            @Override
            @Nullable
            public DrawBatch.Instance createInstance(Vector3ic position, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable DynamicLight light, @Nullable DynamicLight.Type lightType) {
                DrawBatch.Instance instance = this.instanceManager.createInstance(position, dynamicMatrix, staticMatrix, light, lightType);
                if (!(instance instanceof Instance)) {
                    return null;
                }
                Instance instance1 = (Instance)instance;
                instance1.batch = this;
                return instance;
            }
        }
    }

    private record IndirectDrawBlock(int glMode, boolean QUAD, GLBuffer.Allocation drawInfoAlloc, int count, ObjectArrayList<MeshInstanceManager.DrawComponent> drawComponents, boolean multidraw) {
        public IndirectDrawBlock(ObjectArrayList<MeshInstanceManager.DrawComponent> drawComponents, GLBuffer indirectBuffer, boolean multidraw) {
            this(((MeshInstanceManager.DrawComponent)drawComponents.get((int)0)).GL_MODE, ((MeshInstanceManager.DrawComponent)drawComponents.get((int)0)).QUAD, indirectBuffer.alloc(drawComponents.size() * 5 * 4), drawComponents.size(), drawComponents, multidraw);
            this.updateDrawInfo();
        }

        public void draw() {
            if (this.multidraw) {
                if (this.QUAD) {
                    ARBMultiDrawIndirect.glMultiDrawElementsIndirect((int)4, (int)5125, (long)this.drawInfoAlloc.offset(), (int)this.count, (int)0);
                } else {
                    ARBMultiDrawIndirect.glMultiDrawArraysIndirect((int)this.glMode, (long)this.drawInfoAlloc.offset(), (int)this.count, (int)0);
                }
            } else if (this.QUAD) {
                for (int i = 0; i < this.count; ++i) {
                    ARBDrawIndirect.glDrawElementsIndirect((int)4, (int)5125, (long)((long)this.drawInfoAlloc.offset() + (long)i * 20L));
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    ARBDrawIndirect.glDrawArraysIndirect((int)this.glMode, (long)((long)this.drawInfoAlloc.offset() + (long)i * 20L));
                }
            }
        }

        public void updateDrawInfo() {
            IntBuffer drawInfo = this.drawInfoAlloc.buffer().asIntBuffer();
            for (int i = 0; i < this.drawComponents.size(); ++i) {
                MeshInstanceManager.DrawComponent.IndirectDrawInfo indirectInfo = ((MeshInstanceManager.DrawComponent)this.drawComponents.get(i)).indirectInfo();
                drawInfo.put(i * 5, indirectInfo.elementCount);
                drawInfo.put(i * 5 + 1, indirectInfo.instanceCount);
                drawInfo.put(i * 5 + 2, 0);
                drawInfo.put(i * 5 + 3, indirectInfo.baseVertex);
                drawInfo.put(i * 5 + 4, indirectInfo.baseInstance);
            }
        }
    }
}

