/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz;

import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.registry.IgnoreRegistration;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.quartz.internal.gl.GLConfig;
import net.roguelogix.quartz.internal.vk.VKConfig;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class QuartzConfig {
    @IgnoreRegistration
    @RegisterConfig(folder="phosphophyllite", name="quartz", type={ConfigType.CLIENT})
    public static final QuartzConfig INSTANCE = new QuartzConfig();
    public static final boolean INIT_COMPLETED = QuartzConfig.setup();
    @ConfigValue(comment="Backend mode used by quartz\nAutomatic will try to use the best available, and fallback as necessary")
    public final Mode mode = Mode.Automatic;
    @ConfigValue(advanced=ConfigValue.BoolOption.True)
    public final GLConfig GL = GLConfig.INSTANCE;
    @ConfigValue(advanced=ConfigValue.BoolOption.True)
    public final VKConfig VK = VKConfig.INSTANCE;

    private static boolean isValidPhosLoaading() {
        ModFileInfo phosFileInfo = FMLLoader.getLoadingModList().getModFileById("phosphophyllite");
        if (phosFileInfo == null) {
            return false;
        }
        ModFileInfo quartzFileInfo = FMLLoader.getLoadingModList().getModFileById("quartz");
        if (quartzFileInfo == null) {
            throw new IllegalStateException("Quartz not loading");
        }
        IModInfo phosContainer = (IModInfo)phosFileInfo.getMods().get(0);
        IModInfo quartzContainer = (IModInfo)quartzFileInfo.getMods().get(0);
        ArtifactVersion phosVersion = phosContainer.getVersion();
        IModInfo.ModVersion quartzPhosDep = quartzContainer.getDependencies().stream().filter(dep -> dep.getModId().equals("phosphophyllite")).findAny().orElse(null);
        if (quartzPhosDep == null) {
            return false;
        }
        return quartzPhosDep.getVersionRange().containsVersion(phosVersion);
    }

    private static boolean setup() {
        if (!QuartzConfig.isValidPhosLoaading()) {
            return false;
        }
        try {
            ConfigManager.registerConfig((Object)INSTANCE, (String)"quartz", (RegisterConfig)QuartzConfig.class.getField("INSTANCE").getAnnotation(RegisterConfig.class));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        return true;
    }

    public static enum Mode {
        Vulkan10,
        OpenGL33,
        Automatic;

    }
}

