/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.inventory.container.AbstractPylonContainer;
import net.permutated.pylons.tile.AbstractPylonTile;
import net.permutated.pylons.util.TranslationKey;

public abstract class AbstractPylonBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    protected AbstractPylonBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(-1.0f, 1200.0f));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public abstract IContainerFactory<AbstractPylonContainer> containerFactory();

    public abstract BlockEntityType<? extends AbstractPylonTile> getTileType();

    public static boolean canAccessPylon(@Nullable BlockEntity blockEntity, Player player) {
        AbstractPylonTile tile;
        return blockEntity instanceof AbstractPylonTile && (tile = (AbstractPylonTile)blockEntity).canAccess(player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == this.getTileType() ? AbstractPylonTile::tick : null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && entity instanceof Player && !(entity instanceof FakePlayer) && (tileEntity = level.m_7702_(blockPos)) instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            pylonTile.setOwner(entity.m_20148_());
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)blockEntity;
            pylonTile.removeChunkloads();
            pylonTile.dropItems();
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos blockPos) {
        BlockEntity blockEntity = getter.m_7702_(blockPos);
        if (AbstractPylonBlock.canAccessPylon(blockEntity, player)) {
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
            return player.getDigSpeed(state, blockPos) / 2.0f / (float)i;
        }
        return 0.0f;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)blockEntity;
                pylonTile.removeChunkloads();
                pylonTile.dropItems();
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (world.f_46443_) return InteractionResult.SUCCESS;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof AbstractPylonTile) {
            final AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)AbstractPylonBlock.this.m_7705_());
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    pylonTile.updateContainer(buffer);
                    return AbstractPylonBlock.this.containerFactory().create(i, playerInventory, buffer);
                }
            };
            if (!AbstractPylonBlock.canAccessPylon(tileEntity, player)) return InteractionResult.FAIL;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, pylonTile::updateContainer);
            return InteractionResult.SUCCESS;
        } else {
            Pylons.LOGGER.error("tile entity not instance of AbstractPylonTile");
            return InteractionResult.FAIL;
        }
    }

    protected MutableComponent translate(String key) {
        return Component.m_237115_((String)TranslationKey.tooltip(key)).m_130940_(ChatFormatting.GRAY);
    }
}

