/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.item.UpgradeItem;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FilterUpgradeItem
extends UpgradeItem {
    private static final String KEY = "productivebees_allowed_bees";

    public FilterUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public static void addAllowedBee(ItemStack stack, Bee bee) {
        String type = BeeIngredientFactory.getIngredientKey(bee);
        if (type != null) {
            CompoundTag tag = stack.m_41784_();
            Tag list = tag.m_128423_(KEY);
            if (!(list instanceof ListTag)) {
                list = new ListTag();
            }
            for (Tag inbtType : (ListTag)list) {
                if (!inbtType.m_7916_().equals(type)) continue;
                return;
            }
            ((ListTag)list).add((Object)StringTag.m_129297_((String)type));
            tag.m_128365_(KEY, list);
            stack.m_41751_(tag);
        }
    }

    public static List<Supplier<BeeIngredient>> getAllowedBees(ItemStack stack) {
        ListTag list;
        CompoundTag tag = stack.m_41783_();
        ArrayList<Supplier<BeeIngredient>> beeList = new ArrayList<Supplier<BeeIngredient>>();
        if (tag != null && tag.m_128441_(KEY) && (list = (ListTag)tag.m_128423_(KEY)) != null) {
            for (Tag type : list) {
                beeList.add(BeeIngredientFactory.getIngredient(type.m_7916_()));
            }
        }
        return beeList;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        List<Supplier<BeeIngredient>> beeList = FilterUpgradeItem.getAllowedBees(stack);
        for (Supplier<BeeIngredient> allowedBee : beeList) {
            tooltip.add((Component)Component.m_237110_((String)"productivebees.information.upgrade.upgrade_filter_entity", (Object[])new Object[]{allowedBee.get().getBeeType()}).m_130940_(ChatFormatting.GOLD));
        }
        if (beeList.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"productivebees.information.upgrade.upgrade_filter_empty").m_130940_(ChatFormatting.WHITE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"productivebees.information.upgrade.upgrade_filter").m_130940_(ChatFormatting.WHITE));
        }
    }

    @Nonnull
    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity targetIn, InteractionHand hand) {
        if (targetIn.m_20193_().m_5776_() || !(targetIn instanceof Bee)) {
            return InteractionResult.PASS;
        }
        FilterUpgradeItem.addAllowedBee(itemStack, (Bee)targetIn);
        return InteractionResult.SUCCESS;
    }
}

