/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.Collection;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class CreeperBee
extends ProductiveBee
implements IEffectBeeEntity {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(CreeperBee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(CreeperBee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeSinceIgnited;

    public CreeperBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.TEMPER, 2);
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        return flowerBlock.m_204336_(ModTags.POWDERY);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(POWERED, (Object)false);
    }

    @Override
    public void m_8119_() {
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            int fuseTime;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= (fuseTime = 30)) {
                this.timeSinceIgnited = fuseTime;
                this.explode();
            }
        }
        super.m_8119_();
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.m_6084_()) {
            this.setCreeperState(1);
        }
    }

    private void explode() {
        Explosion.BlockInteraction explosionMode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        float f = (Boolean)this.f_19804_.m_135370_(POWERED) != false ? 2.0f : 1.0f;
        this.f_20890_ = true;
        float explosionRadius = 1.6f;
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosionRadius * f, explosionMode);
        this.m_146870_();
        this.spawnLingeringCloud();
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        }
    }

    public int getCreeperState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setCreeperState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightningBolt) {
        super.m_8038_(world, lightningBolt);
        this.f_19804_.m_135381_(POWERED, (Object)true);
    }
}

