/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class NBTUtils {
    public static void initNBTTagCompound(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
    }

    public static boolean hasTag(ItemStack itemStack, String tagName) {
        return itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(tagName);
    }

    public static void removeTag(ItemStack itemStack, String tagName) {
        if (itemStack.m_41783_() != null) {
            itemStack.m_41783_().m_128473_(tagName);
        }
    }

    public static String getString(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setString(itemStack, tagName, "");
        }
        return itemStack.m_41783_().m_128461_(tagName);
    }

    public static void setString(ItemStack itemStack, String tagName, String tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128359_(tagName, tagValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setBoolean(itemStack, tagName, false);
        }
        return itemStack.m_41783_().m_128471_(tagName);
    }

    public static void setBoolean(ItemStack itemStack, String tagName, boolean tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128379_(tagName, tagValue);
    }

    public static byte getByte(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setByte(itemStack, tagName, (byte)0);
        }
        return itemStack.m_41783_().m_128445_(tagName);
    }

    public static void setByte(ItemStack itemStack, String tagName, byte tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128344_(tagName, tagValue);
    }

    public static short getShort(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setShort(itemStack, tagName, (short)0);
        }
        return itemStack.m_41783_().m_128448_(tagName);
    }

    public static void setShort(ItemStack itemStack, String tagName, short tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128376_(tagName, tagValue);
    }

    public static int getInteger(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setInteger(itemStack, tagName, 0);
        }
        return itemStack.m_41783_().m_128451_(tagName);
    }

    public static void setInteger(ItemStack itemStack, String tagName, int tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128405_(tagName, tagValue);
    }

    public static long getLong(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setLong(itemStack, tagName, 0L);
        }
        return itemStack.m_41783_().m_128454_(tagName);
    }

    public static void setLong(ItemStack itemStack, String tagName, long tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128356_(tagName, tagValue);
    }

    public static float getFloat(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setFloat(itemStack, tagName, 0.0f);
        }
        return itemStack.m_41783_().m_128457_(tagName);
    }

    public static void setFloat(ItemStack itemStack, String tagName, float tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128350_(tagName, tagValue);
    }

    public static double getDouble(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            NBTUtils.setDouble(itemStack, tagName, 0.0);
        }
        return itemStack.m_41783_().m_128459_(tagName);
    }

    public static void setDouble(ItemStack itemStack, String tagName, double tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128347_(tagName, tagValue);
    }

    public static CompoundTag getCompoundTag(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.m_41783_().m_128441_(tagName)) {
            itemStack.m_41783_().m_128365_(tagName, (Tag)new CompoundTag());
        }
        return itemStack.m_41783_().m_128469_(tagName);
    }

    public static void setCompoundTag(ItemStack itemStack, String tagName, Tag tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.m_41783_().m_128365_(tagName, tagValue);
    }

    public static void setPos(ItemStack stack, Vec3i vec) {
        NBTUtils.initNBTTagCompound(stack);
        NBTUtils.setPos(stack.m_41783_(), vec);
    }

    public static BlockPos getPos(ItemStack stack) {
        NBTUtils.initNBTTagCompound(stack);
        return NBTUtils.getPos(stack.m_41783_());
    }

    public static void setPos(CompoundTag tag, Vec3i vec) {
        tag.m_128405_("x", vec.m_123341_());
        tag.m_128405_("y", vec.m_123342_());
        tag.m_128405_("z", vec.m_123343_());
    }

    public static BlockPos getPos(CompoundTag tag) {
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    public static boolean fromTag(CompoundTag tag, String name, boolean def) {
        return tag.m_128441_(name) ? tag.m_128471_(name) : def;
    }

    public static int fromTag(CompoundTag tag, String name, int def) {
        return tag.m_128441_(name) ? tag.m_128451_(name) : def;
    }

    public static String fromTag(CompoundTag tag, String name, String def) {
        return tag.m_128441_(name) ? tag.m_128461_(name) : def;
    }

    public static float fromTag(CompoundTag tag, String name, float def) {
        return tag.m_128441_(name) ? tag.m_128457_(name) : def;
    }

    public static ListTag serializeTextComponents(List<Component> textComponents) {
        ListTag l = new ListTag();
        textComponents.forEach(t -> l.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)t))));
        return l;
    }

    public static List<Component> deserializeTextComponents(ListTag l) {
        return l.stream().filter(nbt -> nbt instanceof StringTag).map(nbt -> Component.Serializer.m_130701_((String)nbt.m_7916_())).collect(Collectors.toList());
    }
}

