/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliAccess;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAssemblySystem
implements IComponentProcessor {
    private AssemblyRecipe recipe = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = (AssemblyRecipe)((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL_LASER.get()).getRecipe((Level)Minecraft.m_91087_().f_91073_, recipeId);
        if (this.recipe == null) {
            this.recipe = (AssemblyRecipe)((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get()).getRecipe((Level)Minecraft.m_91087_().f_91073_, recipeId);
            if (this.recipe == null) {
                this.recipe = (AssemblyRecipe)((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_LASER.get()).getRecipe((Level)Minecraft.m_91087_().f_91073_, recipeId);
            }
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        ItemStack programStack = new ItemStack((ItemLike)AssemblyProgramItem.fromProgramType(this.recipe.getProgramType()));
        return switch (key) {
            case "input" -> PatchouliAccess.getStacks(this.recipe.getInput());
            case "output" -> IVariable.from((Object)this.recipe.getOutput());
            case "program" -> IVariable.from((Object)programStack);
            case "name" -> IVariable.wrap((String)this.recipe.getOutput().m_41786_().getString());
            case "desc" -> IVariable.wrap((String)PneumaticCraftUtils.xlate("pneumaticcraft.patchouli.processor.assembly.desc", this.recipe.getOutput().m_41786_(), programStack.m_41786_()).getString());
            default -> null;
        };
    }
}

