/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JEIPressureChamberRecipeCategory
extends AbstractPNCCategory<PressureChamberRecipe> {
    private final ITickTimer tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);

    JEIPressureChamberRecipeCategory() {
        super(RecipeTypes.PRESSURE_CHAMBER, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamber", new Object[0]), (IDrawable)JEIPressureChamberRecipeCategory.guiHelper().createDrawable(Textures.GUI_JEI_PRESSURE_CHAMBER, 5, 11, 166, 116), JEIPressureChamberRecipeCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get())));
    }

    protected static Optional<PressureChamberRecipe.SlotCycle> getMatchingCycle(PressureChamberRecipe recipe, IFocus<ItemStack> focus) {
        List<List> slots;
        if (focus == null) {
            return Optional.empty();
        }
        RecipeIngredientRole role = focus.getRole();
        if (role == RecipeIngredientRole.INPUT) {
            slots = recipe.getInputsForDisplay().stream().map(ingr -> Arrays.asList(ingr.m_43908_())).toList();
        } else if (role == RecipeIngredientRole.OUTPUT) {
            slots = new ArrayList<List<ItemStack>>(recipe.getResultsForDisplay());
        } else {
            return Optional.empty();
        }
        ItemStack needle = (ItemStack)focus.getTypedValue().getIngredient();
        for (int slot = 0; slot < slots.size(); ++slot) {
            List stacks = slots.get(slot);
            if (stacks.size() <= 1) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < stacks.size(); ++i) {
                if (!needle.m_41656_((ItemStack)stacks.get(i))) continue;
                builder.add((Object)i);
            }
            ImmutableList matches = builder.build();
            if (matches.size() <= 0) continue;
            return Optional.of(new PressureChamberRecipe.SlotCycle(new PressureChamberRecipe.RecipeSlot(role == RecipeIngredientRole.INPUT, slot), (ImmutableList<Integer>)matches));
        }
        return Optional.empty();
    }

    protected static List<List<ItemStack>> applyOverrides(boolean isInput, List<List<ItemStack>> slotCycles, Map<PressureChamberRecipe.RecipeSlot, List<Integer>> slotCycleOverrides) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < slotCycles.size(); ++i) {
            List<ItemStack> stacks = slotCycles.get(i);
            List<Integer> cycleOverrides = slotCycleOverrides.get(new PressureChamberRecipe.RecipeSlot(isInput, i));
            if (cycleOverrides != null) {
                builder.add((Object)((List)cycleOverrides.stream().map(stacks::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())));
                continue;
            }
            builder.add(stacks);
        }
        return builder.build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressureChamberRecipe recipe, IFocusGroup focuses) {
        IFocus<ItemStack> focus = this.getItemStackFocus(focuses);
        Map overrides = JEIPressureChamberRecipeCategory.getMatchingCycle(recipe, focus).map(recipe::getSyncForDisplay).orElseGet(ImmutableMap::of);
        List<List<ItemStack>> l = recipe.getInputsForDisplay().stream().map(i -> Arrays.asList(i.m_43908_())).toList();
        List<List<ItemStack>> inputs = JEIPressureChamberRecipeCategory.applyOverrides(true, l, overrides);
        for (int i2 = 0; i2 < inputs.size(); ++i2) {
            int posX = 19 + i2 % 3 * 17;
            int posY = 79 - i2 / 3 * 17;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, posX, posY).setSlotName("in" + i2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs.get(i2))).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe));
        }
        List<List<ItemStack>> outputs = JEIPressureChamberRecipeCategory.applyOverrides(false, recipe.getResultsForDisplay(), overrides);
        for (int i3 = 0; i3 < outputs.size(); ++i3) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 101 + i3 % 3 * 18, 59 + i3 / 3 * 18).setSlotName("out" + i3).addItemStacks(outputs.get(i3))).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe));
        }
    }

    private IFocus<ItemStack> getItemStackFocus(IFocusGroup focuses) {
        return focuses.getFocuses(RecipeIngredientRole.INPUT).filter(f -> f.getTypedValue().getIngredient() instanceof ItemStack).findFirst().orElse(null);
    }

    public void draw(PressureChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        float pressure = recipe.getCraftingPressureForDisplay() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.m_91087_().f_91062_, -1.0f, 7.0f, 5.0f, recipe.getCraftingPressureForDisplay(), pressure, 130, 27);
    }

    public List<Component> getTooltipStrings(PressureChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return this.positionalTooltip(mouseX, mouseY, (x, y) -> x >= 100.0 && y >= 7.0 && x <= 140.0 && y <= 47.0, "pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getCraftingPressureForDisplay()));
    }

    private record Tooltip(PressureChamberRecipe recipe) implements IRecipeSlotTooltipCallback
    {
        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            String tooltipKey = this.recipe.getTooltipKey(recipeSlotView.getRole() == RecipeIngredientRole.INPUT, recipeSlotView.getSlotName().orElse(""));
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(I18n.m_118938_((String)tooltipKey, (Object[])new Object[0])));
            }
        }
    }
}

