/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.minigun;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public abstract class Minigun {
    public static final float MAX_GUN_SPEED = 0.4f;
    private static final float MAX_GUN_YAW_CHANGE = 10.0f;
    private static final float MAX_GUN_PITCH_CHANGE = 10.0f;
    private final boolean requiresTarget;
    private float minigunSpeed;
    private int minigunTriggerTimeOut;
    private final RandomSource rand = RandomSource.m_216343_();
    private float minigunRotation;
    private float oldMinigunRotation;
    public float minigunYaw;
    public float oldMinigunYaw;
    public float minigunPitch;
    public float oldMinigunPitch;
    private boolean sweeping;
    private boolean returning;
    private float sweepingProgress;
    private boolean gunAimedAtTarget;
    private LazyOptional<? extends IAirHandler> airCapability = LazyOptional.empty();
    private int airUsage;
    private ItemStack ammoStack = ItemStack.f_41583_;
    protected final Player player;
    protected Level world;
    private LivingEntity attackTarget;
    private float idleYaw;

    public Minigun(Player player, boolean requiresTarget) {
        this.player = player;
        this.requiresTarget = requiresTarget;
    }

    public Minigun setAirHandler(LazyOptional<? extends IAirHandler> airHandler, int airUsage) {
        this.airCapability = airHandler;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setAmmoStack(@Nonnull ItemStack ammoStack) {
        this.ammoStack = ammoStack;
        return this;
    }

    @Nonnull
    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Minigun setWorld(Level world) {
        this.world = world;
        return this;
    }

    public Level getWorld() {
        return this.world;
    }

    public Minigun setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
        return this;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(@Nonnull ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(SoundEvent var1, float var2, float var3);

    @Nullable
    public abstract Vec3 getMuzzlePosition();

    public abstract Vec3 getLookAngle();

    public abstract float getParticleScale();

    protected int getAmmoColor(@Nonnull ItemStack stack) {
        int n;
        Item item = stack.m_41720_();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem a = (AbstractGunAmmoItem)item;
            n = a.getAmmoColor(stack);
        } else {
            n = -13553359;
        }
        return n;
    }

    public LazyOptional<? extends IAirHandler> getAirCapability() {
        return this.airCapability;
    }

    public PacketPlayMovingSound.MovingSoundFocus getSoundSource() {
        return PacketPlayMovingSound.MovingSoundFocus.of((Entity)this.player);
    }

    public float getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(float minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public float getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(float minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public float getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(float oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public LivingEntity getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = Minigun.clampYaw(idleYaw);
    }

    public boolean isGunAimedAtTarget() {
        return !this.requiresTarget || this.gunAimedAtTarget;
    }

    public boolean tryFireMinigun(Entity target) {
        boolean lastShotOfAmmo = false;
        if (!this.ammoStack.m_41619_() && this.ammoStack.m_41773_() < this.ammoStack.m_41776_() && this.airCapability.map(h -> h.getPressure() > 0.0f).orElse(true).booleanValue()) {
            this.setMinigunTriggerTimeOut(10);
            if (!(this.world.f_46443_ || this.getMinigunSpeed() != 0.4f || this.requiresTarget && !this.gunAimedAtTarget)) {
                HitResult rtr = null;
                AbstractGunAmmoItem ammoItem = (AbstractGunAmmoItem)this.ammoStack.m_41720_();
                if (!this.requiresTarget) {
                    Entity entity;
                    rtr = RayTraceUtils.getMouseOverServer((LivingEntity)this.player, this.getRange());
                    if (rtr instanceof EntityHitResult) {
                        EntityHitResult e = (EntityHitResult)rtr;
                        entity = e.m_82443_();
                    } else {
                        entity = null;
                    }
                    target = entity;
                }
                this.airCapability.ifPresent(airHandler -> {
                    int usage = (int)Math.ceil((float)this.airUsage * ammoItem.getAirUsageMultiplier(this, this.ammoStack));
                    usage += this.getUpgrades((PNCUpgrade)ModUpgrades.RANGE.get());
                    if (this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get()) > 0) {
                        usage *= this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get()) + 1;
                    }
                    if (this.getPlayer() != null && !this.getPlayer().m_7500_()) {
                        airHandler.addAir(-usage);
                    }
                });
                int roundsUsed = 1;
                if (target != null) {
                    if (this.getUpgrades((PNCUpgrade)ModUpgrades.SECURITY.get()) == 0 || !this.securityProtectedTarget(target)) {
                        roundsUsed = ammoItem.onTargetHit(this, this.ammoStack, target);
                    }
                } else if (rtr != null && rtr.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult brtr = (BlockHitResult)rtr;
                    roundsUsed = ammoItem.onBlockHit(this, this.ammoStack, brtr);
                }
                int ammoCost = roundsUsed * ammoItem.getAmmoCost(this.ammoStack);
                lastShotOfAmmo = this.ammoStack.m_220157_(ammoCost, this.rand, this.player instanceof ServerPlayer ? (ServerPlayer)this.player : null) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)this.ammoStack) == 0;
            }
        }
        return lastShotOfAmmo;
    }

    private boolean securityProtectedTarget(Entity target) {
        if (target instanceof TamableAnimal) {
            return ((TamableAnimal)target).m_21826_() != null;
        }
        if (target instanceof DroneEntity) {
            return ((DroneEntity)target).getOwner().m_20148_().equals(this.getPlayer().m_20148_());
        }
        return target instanceof Player;
    }

    public void tick(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && !this.attackTarget.m_6084_()) {
            this.attackTarget = null;
        }
        this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
        this.setAmmoColorStack(this.ammoStack);
        if (this.isMinigunActivated()) {
            this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
            if (this.getMinigunSpeed() == 0.0f) {
                this.playSound((SoundEvent)ModSounds.HUD_INIT.get(), 3.0f, 0.9f);
            }
            float speedBonus = (float)this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get()) * 0.0033f;
            float lastSpeed = this.getMinigunSpeed();
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01f + speedBonus, 0.4f));
            if (!this.world.f_46443_ && this.getMinigunSpeed() > lastSpeed && this.getMinigunSpeed() >= 0.4f) {
                NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.MINIGUN, this.getSoundSource()), this.player.f_19853_, new BlockPos(posX, posY, posZ));
            }
        } else {
            this.setMinigunSpeed(Math.max(0.0f, this.getMinigunSpeed() - 0.003f));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.m_20185_();
            double deltaY = posY - (this.attackTarget.m_20186_() + (double)(this.attackTarget.m_20206_() / 2.0f));
            double deltaZ = posZ - this.attackTarget.m_20189_();
            float targetYaw = (float)Minigun.clampYaw(180.0 - Math.toDegrees(Math.atan2(deltaX, deltaZ)));
            float targetPitch = (float)Math.toDegrees(Math.atan(deltaY / PneumaticCraftUtils.distBetween(0.0, 0.0, deltaX, deltaZ)));
            this.minigunYaw = this.minigunPitch < -80.0f || this.minigunPitch > 80.0f ? targetYaw : this.moveToward(this.minigunYaw, targetYaw, 10.0f, true);
            this.minigunPitch = this.moveToward(this.minigunPitch, targetPitch, 10.0f, false);
            this.gunAimedAtTarget = PneumaticCraftUtils.epsilonEquals(this.minigunYaw, targetYaw) && PneumaticCraftUtils.epsilonEquals(this.minigunPitch, targetPitch);
        } else if (this.isReturning()) {
            this.minigunYaw = this.moveToward(this.minigunYaw, this.idleYaw, 10.0f, true);
            this.minigunPitch = this.moveToward(this.minigunPitch, 0.0f, 10.0f, false);
            if (PneumaticCraftUtils.epsilonEquals(this.minigunYaw, this.idleYaw)) {
                this.setReturning(false);
            }
            this.sweepingProgress = 0.0f;
        } else if (this.isSweeping()) {
            this.minigunYaw = Minigun.clampYaw(this.idleYaw + Mth.m_14031_((float)this.sweepingProgress) * 22.0f);
            this.minigunPitch = this.moveToward(this.minigunPitch, 0.0f, 10.0f, false);
            this.sweepingProgress += 0.05f;
        }
    }

    private float moveToward(float val, float target, float amount, boolean yaw) {
        if (yaw && Math.abs(val - target) > 180.0f) {
            amount = -amount;
        }
        val = val > target ? Math.max(val - amount, target) : Math.min(val + amount, target);
        return yaw ? Minigun.clampYaw(val) : val;
    }

    public int getUpgrades(PNCUpgrade upgrade) {
        return 0;
    }

    public double getRange() {
        double d;
        Item item = this.getAmmoStack().m_41720_();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem a = (AbstractGunAmmoItem)item;
            d = a.getRangeMultiplier(this.ammoStack);
        } else {
            d = 1.0;
        }
        double mul = d;
        return (double)((Integer)ConfigHelper.common().minigun.baseRange.get() + 5 * this.getUpgrades((PNCUpgrade)ModUpgrades.RANGE.get())) * mul;
    }

    public boolean dispenserWeightedPercentage(int basePct) {
        return this.dispenserWeightedPercentage(basePct, 0.1f);
    }

    public boolean dispenserWeightedPercentage(int basePct, float dispenserWeight) {
        return (float)this.getWorld().f_46441_.m_188503_(100) < (float)basePct * (1.0f + (float)this.getUpgrades((PNCUpgrade)ModUpgrades.DISPENSER.get()) * dispenserWeight);
    }

    public static float clampYaw(float yaw) {
        while (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public static double clampYaw(double yaw) {
        while (yaw > 180.0) {
            yaw -= 360.0;
        }
        while (yaw < -180.0) {
            yaw += 360.0;
        }
        return yaw;
    }
}

