/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.Iterator;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.DroneClaimManager;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipeImpl;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MiscEventHandler {
    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_) {
            DroneClaimManager.getInstance(event.level).tick();
            if (event.level.m_46467_() % 100L == 0L) {
                double tickTime = Mth.m_14078_((long[])ServerLifecycleHooks.getCurrentServer().f_129748_) * 1.0E-6;
                NetworkHandler.sendToDimension(new PacketServerTickTime(tickTime), (ResourceKey<Level>)event.level.m_46472_());
            }
        }
    }

    @SubscribeEvent
    public void handleFuelEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack containerStack = event.getItemStack();
        if (containerStack.hasCraftingRemainingItem()) {
            FluidUtil.getFluidContained((ItemStack)containerStack).ifPresent(fluidStack -> PneumaticCraftUtils.getRegistryName(fluidStack.getFluid()).ifPresent(regName -> {
                if ("pneumaticcraft".equals(regName.m_135827_())) {
                    int value = PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(null, fluidStack.getFluid());
                    if (value > 0) {
                        int amountTaken = this.amountTaken(fluidStack.getAmount(), containerStack);
                        double mult = (double)Math.min(amountTaken, fluidStack.getAmount()) / 1000.0;
                        event.setBurnTime((int)((double)value * mult * (Double)ConfigHelper.common().general.fuelBucketEfficiency.get()));
                    } else {
                        event.setBurnTime(-1);
                    }
                }
            }));
        }
    }

    private int amountTaken(int origAmount, ItemStack stack) {
        int newAmount = stack.getCraftingRemainingItem().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount()).orElse(0);
        return origAmount - newAmount;
    }

    @SubscribeEvent
    public void explosionCraftingEvent(ExplosionEvent.Detonate event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.m_6084_() || (stack = itemEntity.m_32055_()).m_41619_()) continue;
            boolean firstItem = true;
            for (ItemStack result : ExplosionCraftingRecipeImpl.tryToCraft(event.getLevel(), stack)) {
                if (firstItem) {
                    itemEntity.m_32045_(result);
                    iterator.remove();
                    firstItem = false;
                    continue;
                }
                PneumaticCraftUtils.dropItemOnGround(result, event.getLevel(), entity.m_20183_());
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof IDroneBase) {
            IDroneBase d = (IDroneBase)entity;
            MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(d));
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        HitResult hitResult = event.getTarget();
        if (hitResult instanceof BlockHitResult) {
            LiquidBlock l;
            BlockHitResult brtr = (BlockHitResult)hitResult;
            hitResult = event.getLevel().m_8055_(brtr.m_82425_()).m_60734_();
            if (hitResult instanceof LiquidBlock && (l = (LiquidBlock)hitResult).getFluid().m_205067_(PneumaticCraftTags.Fluids.CRUDE_OIL) && (hitResult = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)hitResult;
                AdvancementTriggers.OIL_BUCKET.trigger(sp);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!event.isCanceled() && state.m_60734_() instanceof IPneumaticWrenchable) {
            if (event.getHand() == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().m_21120_(InteractionHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().m_21120_(event.getHand()))) {
                if (event.getLevel().f_46443_) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getFace(), event.getHand()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getTarget() instanceof IPneumaticWrenchable) {
            if (event.getHand() == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().m_21120_(InteractionHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().m_21120_(event.getHand()))) {
                if (event.getLevel().f_46443_) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getHand(), event.getTarget().m_19879_()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        String username = event.getUsername();
        ServerPlayer player = event.getPlayer();
        if (player != null && username != null && username.equals("Quetzz") && event.getMessage().equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.f_11830_, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, true), player);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level world = (Level)levelAccessor;
            if (!world.f_46443_) {
                ModuleNetworkManager.getInstance(world).invalidateCache();
            }
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof ProgrammerBlockEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND && event.getTo().m_41720_() instanceof IPositionProvider) {
                ((IPositionProvider)event.getTo().m_41720_()).syncVariables(player, event.getTo());
            } else if (event.getSlot() == EquipmentSlot.MAINHAND) {
                if (event.getTo().m_41720_() instanceof MinigunItem) {
                    ((MinigunItem)event.getTo().m_41720_()).onEquipmentChange(player, event.getTo(), true);
                } else if (event.getFrom().m_41720_() instanceof MinigunItem) {
                    ((MinigunItem)event.getFrom().m_41720_()).onEquipmentChange(player, event.getFrom(), false);
                }
            } else if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                for (ItemStack stack : player.m_6168_()) {
                    if (stack.m_41720_() instanceof PneumaticArmorItem) continue;
                    return;
                }
                AdvancementTriggers.PNEUMATIC_ARMOR.trigger(player);
            }
        }
    }

    @SubscribeEvent
    public void entityMounting(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityMounting() instanceof DroneEntity && (event.getEntityBeingMounted() instanceof AbstractMinecart || event.getEntityBeingMounted() instanceof Boat) && !event.getEntityBeingMounted().m_20096_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        CommonArmorRegistry.getInstance().resolveBlockTags();
        PneumaticRegistry.getInstance().getMiscHelpers().registerXPFluid(FluidIngredient.of(1, PneumaticCraftTags.Fluids.EXPERIENCE), 20);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getSpawner() != null) {
            event.getEntity().m_20049_("pneumaticcraft:defender");
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                ISemiBlock semi;
                Level level = (Level)levelAccessor;
                BlockEntity be = event.getSpawner().getSpawnerBlockEntity();
                if (be != null && (semi = SemiblockTracker.getInstance().getSemiblock(level, be.m_58899_())) instanceof SpawnerAgitatorEntity) {
                    event.getEntity().m_21530_();
                }
            }
        }
    }
}

