/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.HeatSinkBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeatSinkBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.IHeatTintable,
PneumaticCraftEntityBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public HeatSinkBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return SHAPES[this.getRotation(state).m_122411_()];
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return state == null ? null : (BlockState)state.m_61124_((Property)this.directionProperty(), (Comparable)ctx.m_43719_().m_122424_());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, HeatSinkBlockEntity.class).ifPresent(te -> {
            double temp = te.getHeatExchanger().getTemperature();
            if (temp > 333.0) {
                entity.m_6469_(DamageSource.f_19309_, 1.0f + ((float)temp - 333.0f) * 0.05f);
                if (temp > 373.0) {
                    entity.m_20254_(3);
                }
            } else if (temp < 243.0) {
                entity.m_146924_(true);
                if (temp < 213.0) {
                    boolean canFreeze = entity.m_142079_();
                    int amplifier = (int)((243.0 - temp) / 20.0) + (canFreeze ? 0 : 3);
                    entity.m_146917_(Math.min(entity.m_146888_() + amplifier, entity.m_146891_() + 2));
                    if (entity.m_146888_() >= entity.m_146891_()) {
                        float dmg;
                        int durationTicks = (int)((243.0 - temp) * 2.0);
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, durationTicks, amplifier));
                        float f = dmg = entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 5.0f : 2.0f;
                        if (!canFreeze) {
                            dmg /= 2.0f;
                        }
                        entity.m_6469_(DamageSource.f_146701_, dmg);
                    }
                }
            }
        });
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new HeatSinkBlockEntity(pPos, pState);
    }
}

