/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.DroneDebuggerOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.DroneDebugHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;

public class DroneDebugClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<DroneDebugHandler> {
    private final Set<BlockPos> shownPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> shownArea = new HashSet<BlockPos>();

    public DroneDebugClientHandler() {
        super(CommonUpgradeHandlers.droneDebugHandler);
    }

    public static void onWidgetsChanged() {
        DroneDebuggerOptions db;
        IDroneBase drone;
        ArmorMainScreen a;
        Object object = Minecraft.m_91087_().f_91080_;
        if (object instanceof ArmorMainScreen && (object = (a = (ArmorMainScreen)object).getCurrentOptionsPage().page()) instanceof DroneDebuggerOptions && (drone = (db = (DroneDebuggerOptions)object).getSelectedDrone()) != null) {
            ProgrammerBlockEntity.updatePuzzleConnections(drone.getProgWidgets());
            db.gotoStartWidget();
        }
    }

    public Set<BlockPos> getShowingPositions() {
        return this.shownPositions;
    }

    public Set<BlockPos> getShownArea() {
        return this.shownArea;
    }

    @Override
    public Optional<KeyMapping> getTriggerKeyBinding() {
        return Optional.of(KeyHandler.getInstance().keybindDebuggingDrone);
    }

    @Override
    public void onTriggered(ICommonArmorHandler armorHandler) {
        if (DroneDebugClientHandler.enabledForPlayer((Player)Minecraft.m_91087_().f_91074_)) {
            ClientArmorRegistry c = ClientArmorRegistry.getInstance();
            ArmorUpgradeRegistry r = ArmorUpgradeRegistry.getInstance();
            c.getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).selectAsDebuggingTarget();
        }
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
    }

    @Override
    public void render2D(PoseStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new DroneDebuggerOptions(screen, this);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    public static boolean enabledForPlayer(Player player) {
        if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.HEAD)) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            return handler.getUpgradeCount(EquipmentSlot.HEAD, (PNCUpgrade)ModUpgrades.DISPENSER.get()) > 0;
        }
        return false;
    }
}

