/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WidgetAnimatedStat
extends AbstractWidget
implements IGuiAnimatedStat,
ITooltipProvider {
    private static final int MIN_WIDTH_HEIGHT = 17;
    private static final int MAX_VISIBLE_LINES = 12;
    private static final int SCROLLBAR_MARGIN_WIDTH = 20;
    private static final int TOP_MARGIN_HEIGHT = 20;
    private IGuiAnimatedStat statAbove;
    private StatIcon statIcon;
    private final Screen gui;
    private final List<Component> textComponents = new ArrayList<Component>();
    private final List<FormattedCharSequence> reorderingProcessors = new ArrayList<FormattedCharSequence>();
    private final List<Boolean> dropShadows = new ArrayList<Boolean>();
    private final List<AbstractWidget> subWidgets = new ArrayList<AbstractWidget>();
    private int effectiveY;
    private int reservedLines = 0;
    private boolean autoLineWrap = true;
    private int prevX;
    private int prevEffectiveY;
    private int prevWidth;
    private int prevHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int minExpandedHeight;
    private int minExpandedWidth;
    private int expandedWidth;
    private int expandedHeight;
    private int backGroundColor;
    private TintColor bgColorHi;
    private TintColor bgColorLo;
    private boolean leftSided;
    private boolean doneExpanding;
    private int curScroll;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private WidgetVerticalScrollbar scrollBar = null;
    private boolean needTextRecalc = true;
    private int foregroundColor = -1;
    private int titleColor = -256;
    private List<Component> extraTooltipText = new ArrayList<Component>();

    public WidgetAnimatedStat(Screen gui, Component title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        super(xPos, yPos, 17, 17, title);
        this.gui = gui;
        this.statAbove = statAbove;
        this.leftSided = leftSided;
        this.statIcon = StatIcon.NONE;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.effectiveY = this.f_93621_;
        if (statAbove != null) {
            this.effectiveY += statAbove.getEffectiveY() + statAbove.getStatHeight();
        }
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, (Component)Component.m_237119_(), 0, 0, backgroundColor, null, false);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ResourceLocation texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(texture);
    }

    public WidgetAnimatedStat(Screen gui, Component title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, statAbove, leftSided);
        this.statIcon = icon;
    }

    public WidgetAnimatedStat(Screen gui, Component title, StatIcon icon, int backGroundColor, IGuiAnimatedStat statAbove, StatPanelLayout layout) {
        this(gui, title, 0, 0, backGroundColor, statAbove, layout.expandsLeft());
        Window mw = Minecraft.m_91087_().m_91268_();
        int x = layout.x() == -1.0f ? mw.m_85445_() - 2 : (int)((float)mw.m_85445_() * layout.x());
        this.setBaseX(x);
        this.setBaseY((int)((float)mw.m_85446_() * layout.y()));
        this.statIcon = icon;
    }

    public void m_93666_(Component message) {
        super.m_93666_(message);
        this.needTextRecalc = true;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.statAbove = stat;
    }

    @Override
    public void addSubWidget(AbstractWidget widget) {
        this.subWidgets.add(widget);
    }

    public void removeSubWidget(AbstractWidget widget) {
        this.subWidgets.remove(widget);
    }

    @Override
    public void setSubwidgetRenderOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public void setAutoLineWrap(boolean wrap) {
        this.autoLineWrap = wrap;
    }

    @Override
    public Component getTitle() {
        return this.m_6035_();
    }

    @Override
    public void setTitle(Component title) {
        this.m_93666_(title);
    }

    @Override
    public IGuiAnimatedStat setText(List<Component> text) {
        this.textComponents.clear();
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(Component text) {
        this.textComponents.clear();
        this.textComponents.add(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public void appendText(List<Component> text) {
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.backGroundColor) {
            this.backGroundColor = backgroundColor;
            this.calculateColorHighlights(backgroundColor);
        }
    }

    @Override
    public void setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    @Override
    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (((Boolean)ConfigHelper.client().general.guiBevel.get()).booleanValue()) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            TintColor c = new TintColor(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = new TintColor(color).darker().darker();
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private int getVisibleLines() {
        return 12 - this.reservedLines;
    }

    @Override
    public void setReservedLines(int reservedLines) {
        this.reservedLines = Mth.m_14045_((int)reservedLines, (int)0, (int)11);
        this.needTextRecalc = true;
    }

    private void recalcText() {
        int n;
        this.reorderingProcessors.clear();
        this.dropShadows.clear();
        Font font = Minecraft.m_91087_().f_91062_;
        int titleWidth = font.m_92852_((FormattedText)this.m_6035_());
        if (this.autoLineWrap) {
            int availableWidth = this.calculateAvailableWidth();
            this.reorderingProcessors.addAll(GuiUtils.wrapTextComponentList(this.textComponents, availableWidth, font));
            this.expandedWidth = Math.min(availableWidth, Math.max(titleWidth, this.minExpandedWidth));
        } else {
            this.expandedWidth = titleWidth;
            this.textComponents.forEach(c -> this.reorderingProcessors.add(c.m_7532_()));
        }
        this.reorderingProcessors.forEach(processedLine -> {
            this.expandedWidth = Math.max(this.expandedWidth, font.m_92724_(processedLine));
            this.dropShadows.add(this.needsDropShadow((FormattedCharSequence)processedLine));
        });
        this.expandedWidth += 20;
        if (this.reorderingProcessors.isEmpty()) {
            Objects.requireNonNull(font);
            n = 9;
        } else {
            n = 20;
        }
        int topMargin = n;
        int n2 = Math.min(12, this.reorderingProcessors.size() + this.reservedLines);
        Objects.requireNonNull(font);
        this.expandedHeight = Math.max(this.minExpandedHeight, topMargin + n2 * 9) + 3;
        this.addOrRemoveScrollbar();
        this.needTextRecalc = false;
    }

    private int calculateAvailableWidth() {
        int availableWidth;
        Screen screen = this.gui;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            availableWidth = Math.min(Math.max(this.minExpandedWidth, screen2.getXSize()), this.leftSided ? screen2.getGuiLeft() : screen2.f_96543_ - (screen2.getGuiLeft() + screen2.getXSize()));
        } else {
            screen = this.gui;
            if (screen instanceof AbstractPneumaticCraftScreen) {
                AbstractPneumaticCraftScreen screen3 = (AbstractPneumaticCraftScreen)screen;
                availableWidth = Math.min(Math.max(this.minExpandedWidth, screen3.xSize), this.leftSided ? screen3.guiLeft : screen3.xSize - (screen3.guiLeft + screen3.xSize));
            } else {
                availableWidth = this.leftSided ? this.f_93620_ : Minecraft.m_91087_().m_91268_().m_85445_() - this.f_93620_;
            }
        }
        return availableWidth - 5 - 20;
    }

    private boolean needsDropShadow(FormattedCharSequence line) {
        StyleChecker styleChecker = new StyleChecker(this.foregroundColor);
        line.m_13731_((FormattedCharSink)styleChecker);
        return styleChecker.isLightColor();
    }

    private void addOrRemoveScrollbar() {
        if (this.reorderingProcessors.size() > this.getVisibleLines()) {
            int n;
            if (this.subWidgets.contains(this.scrollBar)) {
                return;
            }
            this.curScroll = 0;
            int scrollbarHeight = this.getVisibleLines() * this.lineSpacing - 20;
            if (this.reservedLines > 0) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                n = this.reservedLines * 9;
            } else {
                n = 0;
            }
            int yOffset = n;
            this.scrollBar = new WidgetVerticalScrollbar(this.leftSided ? -16 : 2, 20 + yOffset, scrollbarHeight).setStates(this.reorderingProcessors.size() - this.getVisibleLines()).setListening(true);
            this.addSubWidget(this.scrollBar);
        } else if (this.subWidgets.removeIf(w -> w == this.scrollBar)) {
            this.curScroll = 0;
            this.scrollBar = null;
        }
    }

    @Override
    public void setMinimumContractedDimensions(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.f_93618_ = minWidth;
        this.f_93619_ = minHeight;
    }

    @Override
    public void setMinimumExpandedDimensions(int minWidth, int minHeight) {
        if (this.minExpandedWidth != minWidth) {
            this.needTextRecalc = true;
        }
        this.minExpandedWidth = minWidth;
        this.minExpandedHeight = minHeight;
    }

    @Override
    public void tickWidget() {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        this.prevX = this.f_93620_;
        this.prevEffectiveY = this.effectiveY;
        this.prevWidth = this.f_93618_;
        this.prevHeight = this.f_93619_;
        this.doneExpanding = true;
        int expandX = this.expandedWidth / 4;
        int expandY = this.expandedHeight / 4;
        if (this.isClicked) {
            this.f_93618_ = Math.min(this.expandedWidth, this.f_93618_ + expandX);
            this.f_93619_ = Math.min(this.expandedHeight, this.f_93619_ + expandY);
            this.doneExpanding = this.f_93618_ == this.expandedWidth && this.f_93619_ == this.expandedHeight;
            int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
            if (this.isLeftSided()) {
                if (this.f_93620_ >= scaledWidth) {
                    this.f_93620_ = scaledWidth;
                }
            } else if (this.f_93620_ < 0) {
                this.f_93620_ = 1;
            }
            if (this.f_93621_ + this.f_93619_ >= scaledHeight) {
                this.f_93621_ = scaledHeight - this.f_93619_ - 1;
            }
            if (this.doneExpanding && this.scrollBar != null) {
                this.curScroll = this.scrollBar.getState();
            }
        } else {
            this.f_93618_ = Math.max(this.minWidth, this.f_93618_ - expandX);
            this.f_93619_ = Math.max(this.minHeight, this.f_93619_ - expandY);
            this.doneExpanding = false;
        }
        this.effectiveY = this.f_93621_;
        if (this.statAbove != null) {
            this.effectiveY += this.statAbove.getEffectiveY() + this.statAbove.getStatHeight();
        }
    }

    @Override
    public void renderStat(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_6303_(matrixStack, x, y, partialTicks);
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        if (this.leftSided) {
            return this.f_93623_ && this.f_93624_ && mouseX >= (double)this.f_93620_ - (double)this.f_93618_ && mouseX < (double)this.f_93620_ && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        }
        return super.m_93680_(mouseX, mouseY);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        int baseX = this.leftSided ? this.f_93620_ - this.f_93618_ : this.f_93620_;
        this.f_93622_ = mouseX >= baseX && mouseY >= this.effectiveY && mouseX < baseX + this.f_93618_ && mouseY < this.effectiveY + this.f_93619_;
        float zLevel = 0.0f;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int renderBaseX = (int)Mth.m_14179_((float)partialTicks, (float)this.prevX, (float)this.f_93620_);
        int renderAffectedY = (int)Mth.m_14179_((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)Mth.m_14179_((float)partialTicks, (float)this.prevWidth, (float)this.f_93618_);
        int renderHeight = (int)Mth.m_14179_((float)partialTicks, (float)this.prevHeight, (float)this.f_93619_);
        int xOff = 1;
        if (this.leftSided) {
            renderWidth *= -1;
            xOff = -1;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        int sideU = this.bgColorHi.getRGB();
        int sideD = this.bgColorLo.getRGB();
        int sideL = this.leftSided ? sideD : sideU;
        int sideR = this.leftSided ? sideU : sideD;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)renderBaseX, (int)(renderAffectedY - 1), (int)(renderBaseX + renderWidth), (int)renderAffectedY, (int)sideU);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(renderBaseX + renderWidth), (int)renderAffectedY, (int)(renderBaseX + renderWidth + xOff), (int)(renderAffectedY + renderHeight), (int)sideR);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)renderBaseX, (int)(renderAffectedY + renderHeight), (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight + 1), (int)sideD);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(renderBaseX - xOff), (int)renderAffectedY, (int)renderBaseX, (int)(renderAffectedY + renderHeight), (int)sideL);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            String title;
            int titleYoffset;
            if (this.needTextRecalc) {
                this.recalcText();
            }
            int n = titleYoffset = (title = this.m_6035_().getString()).isEmpty() ? 3 : 12;
            if (!title.isEmpty()) {
                fontRenderer.m_92750_(matrixStack, title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), this.titleColor);
            }
            for (int i = this.curScroll; i < this.reorderingProcessors.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                FormattedCharSequence line = this.reorderingProcessors.get(i);
                int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
                Objects.requireNonNull(fontRenderer);
                int renderY = renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset + this.reservedLines * 9;
                if (this.dropShadows.get(i).booleanValue()) {
                    fontRenderer.m_92744_(matrixStack, line, (float)renderX, (float)renderY, this.foregroundColor);
                    continue;
                }
                fontRenderer.m_92877_(matrixStack, line, (float)renderX, (float)renderY, this.foregroundColor);
            }
            PoseStack poseStack = RenderSystem.m_157191_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderAffectedY + (titleYoffset - 10)), 0.0);
            RenderSystem.m_69493_();
            RenderSystem.m_157182_();
            this.subWidgets.forEach(widget -> widget.m_6305_(matrixStack, mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks));
            poseStack.m_85849_();
            RenderSystem.m_157182_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render(matrixStack, renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    @Override
    public void renderStat(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        int renderBaseX = (int)Mth.m_14179_((float)partialTicks, (float)this.prevX, (float)this.f_93620_);
        int renderEffectiveY = (int)Mth.m_14179_((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)Mth.m_14179_((float)partialTicks, (float)this.prevWidth, (float)this.f_93618_);
        int renderHeight = (int)Mth.m_14179_((float)partialTicks, (float)this.prevHeight, (float)this.f_93619_);
        int[] cols = RenderUtils.decomposeColor(this.backGroundColor);
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH, (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            builder.m_85982_(posMat, (float)renderBaseX, (float)renderEffectiveY + (float)renderHeight, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY + (float)renderHeight, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, (float)renderBaseX, (float)renderEffectiveY, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_85969_(0xF000F0).m_5752_();
        });
        Matrix3f normal = matrixStack.m_85850_().m_85864_();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoops(5.0), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
            float[] c2 = this.bgColorHi.getComponents(null);
            float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
            float[] c4 = this.bgColorLo.getComponents(null);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY, 0.0f, c1[0], c1[1], c1[2], c1[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX + rw, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY + this.f_93619_, 0.0f, c2[0], c2[1], c2[2], c2[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX + rw, renderEffectiveY + this.f_93619_, 0.0f, renderBaseX, renderEffectiveY + this.f_93619_, 0.0f, c3[0], c3[1], c3[2], c3[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY + this.f_93619_, 0.0f, renderBaseX, renderEffectiveY, 0.0f, c4[0], c4[1], c4[2], c4[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY, 0.0f, c1[0], c1[1], c1[2], c1[3], true);
        });
        if (this.doneExpanding) {
            matrixStack.m_85836_();
            String title = this.m_6035_().getString();
            if (!title.isEmpty()) {
                RenderUtils.renderString3d((Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.UNDERLINE), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderEffectiveY + 2, this.titleColor, matrixStack, buffer, false, true);
            }
            int titleOffsetY = title.isEmpty() ? 3 : 12;
            Font font = Minecraft.m_91087_().f_91062_;
            for (int i = this.curScroll; i < this.textComponents.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
                Objects.requireNonNull(font);
                int renderY = renderEffectiveY + (i - this.curScroll) * this.lineSpacing + titleOffsetY + this.reservedLines * 9;
                font.m_92733_(this.reorderingProcessors.get(i), (float)renderX, (float)renderY, this.foregroundColor, this.dropShadows.get(i).booleanValue(), matrixStack.m_85850_().m_85861_(), buffer, true, 0, 0xF000F0);
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderEffectiveY + (titleOffsetY - 10)), 0.0);
            this.subWidgets.stream().filter(widget -> widget instanceof ICanRender3d).forEach(widget -> ((ICanRender3d)widget).render3d(matrixStack, buffer, partialTicks));
            matrixStack.m_85849_();
            matrixStack.m_85849_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render3d(matrixStack, buffer, renderBaseX, renderEffectiveY);
        }
    }

    private void toggle() {
        boolean bl = this.isClicked = !this.isClicked;
        if (this.isClicked && this.gui instanceof AbstractPneumaticCraftContainerScreen) {
            List<IGuiAnimatedStat> otherStats = ((AbstractPneumaticCraftContainerScreen)this.gui).getStatWidgets();
            otherStats.stream().filter(stat -> this != stat && stat.isLeftSided() == this.isLeftSided()).forEach(IGuiAnimatedStat::closeStat);
            this.subWidgets.stream().filter(w -> w instanceof EditBox).findFirst().ifPresent(w -> ((EditBox)w).m_94178_(true));
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.getBounds().m_110087_((int)mouseX, (int)mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_198029_()) {
            for (AbstractWidget widget : this.subWidgets) {
                if (!widget.m_6375_(mouseX - (double)this.f_93620_, mouseY - (double)this.effectiveY, button)) continue;
                return true;
            }
            this.toggle();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_198029_()) {
            for (AbstractWidget widget : this.subWidgets) {
                if (!widget.m_6348_(mouseX - (double)this.f_93620_, mouseY - (double)this.effectiveY, button)) continue;
                return true;
            }
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.m_198029_()) {
            Rect2i bounds = this.getBounds();
            for (AbstractWidget widget : this.subWidgets) {
                if (!widget.m_7979_(mouseX - (double)bounds.m_110085_(), mouseY - (double)bounds.m_110086_(), button, dragX, dragY)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double dir) {
        Rect2i bounds = this.getBounds();
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.m_93696_() || !widget.m_6050_(x - (double)bounds.m_110085_(), y - (double)bounds.m_110086_(), dir)) continue;
            return true;
        }
        return this.scrollBar != null && this.scrollBar.m_6050_(x, y, dir);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.m_7933_(keyCode, scanCode, modifiers) && (!(widget instanceof EditBox) || !widget.m_93696_() || keyCode == 256)) continue;
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.m_5534_(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeStat() {
        this.isClicked = false;
    }

    @Override
    public void openStat() {
        this.isClicked = true;
    }

    @Override
    public boolean isStatOpen() {
        return this.isClicked;
    }

    @Override
    public int getEffectiveY() {
        return this.effectiveY;
    }

    @Override
    public int getBaseX() {
        return this.f_93620_;
    }

    @Override
    public int getBaseY() {
        return this.f_93621_;
    }

    @Override
    public int getStatHeight() {
        return this.m_93694_();
    }

    @Override
    public int getStatWidth() {
        return this.m_5711_();
    }

    @Override
    public void setBaseY(int y) {
        this.f_93621_ = y;
    }

    @Override
    public void setBaseX(int x) {
        this.f_93620_ = x;
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.f_93620_ - (this.leftSided ? this.f_93618_ : 0), this.effectiveY, this.f_93618_, this.f_93619_);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.m_6035_());
            curTooltip.addAll(this.getExtraTooltipText());
        }
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.m_198029_() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    public void setExtraTooltipText(List<Component> extraTooltipText) {
        this.extraTooltipText = extraTooltipText;
    }

    private List<Component> getExtraTooltipText() {
        return this.extraTooltipText;
    }

    private boolean mouseIsHoveringOverIcon(double x, double y) {
        if (this.leftSided) {
            return x <= (double)this.f_93620_ && x >= (double)(this.f_93620_ - 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
        }
        return x >= (double)this.f_93620_ && x <= (double)(this.f_93620_ + 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
    }

    @Override
    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    @Override
    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class StatIcon {
        public static final StatIcon NONE = StatIcon.of(ItemStack.f_41583_);
        private final Either<ItemStack, ResourceLocation> texture;

        private StatIcon(Either<ItemStack, ResourceLocation> texture) {
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)stack));
        }

        public static StatIcon of(ItemLike item) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)new ItemStack(item, 1)));
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.right((Object)texture));
        }

        void render(PoseStack matrixStack, int x, int y, boolean leftSided) {
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            this.texture.ifLeft(stack -> Minecraft.m_91087_().m_91291_().m_115123_(stack, x - (leftSided ? 16 : 0), y)).ifRight(resLoc -> GuiUtils.drawTexture(matrixStack, resLoc, x - (leftSided ? 16 : 0), y));
            RenderSystem.m_69461_();
        }

        public void render3d(PoseStack matrixStack, MultiBufferSource buffer, int x, int y) {
            this.texture.ifLeft(stack -> {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(x + 8), (double)(y + 8), 0.0);
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrixStack.m_85841_(15.0f, 15.0f, 1.0f);
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel ibakedmodel = itemRenderer.m_174264_(stack, ClientUtils.getClientLevel(), null, 0);
                itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, true, matrixStack, buffer, 0xF000F0, OverlayTexture.f_118083_, ibakedmodel);
                matrixStack.m_85849_();
            }).ifRight(resLoc -> RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(resLoc), (posMat, builder) -> RenderUtils.drawTexture(matrixStack, builder, x, y, 0xF000F0)));
        }
    }

    private static class StyleChecker
    implements FormattedCharSink {
        private static final int THRESHOLD = 129;
        Style style = Style.f_131099_;
        private final int defColor;

        private StyleChecker(int defColor) {
            this.defColor = defColor;
        }

        public boolean m_6411_(int p_accept_1_, Style p_accept_2_, int p_accept_3_) {
            if (this.style == Style.f_131099_) {
                this.style = p_accept_2_;
            }
            return true;
        }

        public boolean isLightColor() {
            int c = this.style == null || this.style.m_131179_() || this.style.m_131135_() == null ? this.defColor : this.style.m_131135_().m_131265_();
            return this.isLightColor(new TintColor(c));
        }

        private boolean isLightColor(TintColor bg) {
            int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
            return luminance > 129;
        }
    }
}

