/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.EnumMap;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.JackhammerSetupMenu;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class JackHammerSetupScreen
extends AbstractPneumaticCraftContainerScreen<JackhammerSetupMenu, AbstractPneumaticCraftBlockEntity> {
    private final EnumMap<JackHammerItem.DigMode, WidgetButtonExtended> typeButtons = new EnumMap(JackHammerItem.DigMode.class);
    private WidgetButtonExtended selectorButton;

    public JackHammerSetupScreen(JackhammerSetupMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 182;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        ItemStack hammerStack = ClientUtils.getClientPlayer().m_21120_(((JackhammerSetupMenu)this.f_97732_).getHand());
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(hammerStack);
        if (digMode != null) {
            this.selectorButton = new WidgetButtonExtended(this.f_97735_ + 127, this.f_97736_ + 67, 20, 20, (Component)Component.m_237119_(), b -> this.toggleShowChoices());
            ((WidgetButtonExtended)this.m_142416_((GuiEventListener)this.selectorButton)).setRenderedIcon(digMode.getGuiIcon());
            int xBase = 147 - 20 * JackHammerItem.DigMode.values().length;
            for (JackHammerItem.DigMode dm : JackHammerItem.DigMode.values()) {
                WidgetButtonExtended button = new WidgetButtonExtended(this.f_97735_ + xBase, this.f_97736_ + 47, 20, 20, (Component)Component.m_237119_(), b -> this.selectDigMode(dm)).setRenderedIcon(dm.getGuiIcon()).withTag("digmode:" + dm);
                xBase += 20;
                button.f_93624_ = false;
                this.typeButtons.put(dm, button);
                this.m_142416_((GuiEventListener)button);
            }
        }
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.f_97735_ + 96, this.f_97736_ + 19, 18, 18, new Component[0]){

            @Override
            public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shiftPressed) {
                if (!((Slot)((JackhammerSetupMenu)((JackHammerSetupScreen)JackHammerSetupScreen.this).f_97732_).f_38839_.get(1)).m_6657_()) {
                    curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.jackhammer.enchantedBookTip", new Object[0]));
                }
            }
        });
    }

    private void selectDigMode(JackHammerItem.DigMode digMode) {
        this.typeButtons.values().forEach(button -> {
            button.f_93624_ = false;
        });
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    private void toggleShowChoices() {
        this.typeButtons.values().forEach(button -> {
            button.f_93624_ = !button.f_93624_;
        });
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.updateDigModeButtons();
    }

    private void updateDigModeButtons() {
        ItemStack drillStack = ((JackhammerSetupMenu)this.f_97732_).m_38853_(0).m_7993_();
        DrillBitItem.DrillBitType bitType = drillStack.m_41720_() instanceof DrillBitItem ? ((DrillBitItem)drillStack.m_41720_()).getType() : DrillBitItem.DrillBitType.NONE;
        ItemStack hammerStack = ClientUtils.getClientPlayer().m_21120_(((JackhammerSetupMenu)this.f_97732_).getHand());
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(hammerStack);
        if (digMode == null) {
            digMode = JackHammerItem.DigMode.MODE_1X1;
        }
        this.typeButtons.forEach((dm, button) -> {
            button.f_93623_ = bitType.getBitQuality() >= dm.getBitType().getBitQuality();
        });
        if (digMode.getBitType().getBitQuality() > bitType.getBitQuality() && digMode != JackHammerItem.DigMode.MODE_1X1) {
            digMode = JackHammerItem.DigMode.MODE_1X1;
            NetworkHandler.sendToServer(new PacketGuiButton("digmode:" + digMode));
        }
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (!((Slot)((JackhammerSetupMenu)this.f_97732_).f_38839_.get(0)).m_6657_()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.jackhammer.noBit", new Object[0]));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_JACKHAMMER_SETUP;
    }
}

