/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.ChargingStationMenu;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class ChargingStationScreen
extends AbstractPneumaticCraftContainerScreen<ChargingStationMenu, ChargingStationBlockEntity> {
    private static final int PARTICLE_COUNT = 10;
    private WidgetButtonExtended guiSelectButton;
    private WidgetButtonExtended upgradeOnlyButton;
    private float renderAirProgress;
    private static final Component UPGRADE_ONLY_ON = Component.m_237113_((String)"\u2b06").m_130940_(ChatFormatting.AQUA);
    private static final Component UPGRADE_ONLY_OFF = Component.m_237113_((String)"\u2b06").m_130940_(ChatFormatting.GRAY);

    public ChargingStationScreen(ChargingStationMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 182;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.guiSelectButton = new WidgetButtonExtended(this.f_97735_ + 90, this.f_97736_ + 22, 18, 19, (Component)Component.m_237119_()).withTag("open_upgrades");
        this.guiSelectButton.setRenderedIcon(Textures.GUI_UPGRADES_LOCATION);
        this.guiSelectButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.guiSelectButton);
        this.upgradeOnlyButton = new WidgetButtonExtended(this.f_97735_ + 129, this.f_97736_ + 80, 14, 14, "U").withTag("toggle_upgrade_only");
        this.m_142416_((GuiEventListener)this.upgradeOnlyButton);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_CHARGING_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        super.m_7286_(matrixStack, partialTicks, x, y);
        if (((ChargingStationBlockEntity)this.te).upgradeOnly) {
            this.m_93228_(matrixStack, this.f_97735_ + 102, this.f_97736_ + 76, 177, 0, 13, 16);
        } else {
            this.renderAir(matrixStack, partialTicks);
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        ItemStack stack = ((ChargingStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0);
        this.guiSelectButton.f_93624_ = stack.m_41720_() instanceof IChargeableContainerProvider;
        if (this.guiSelectButton.f_93624_) {
            this.guiSelectButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.charging_station.manageUpgrades", stack.m_41786_()));
        }
        if (!((ChargingStationBlockEntity)this.te).upgradeOnly) {
            if (((ChargingStationBlockEntity)this.te).charging) {
                this.renderAirProgress += 0.001f * Math.min(25.0f, ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
                if (this.renderAirProgress > 1.0f) {
                    this.renderAirProgress = 0.0f;
                }
            } else if (((ChargingStationBlockEntity)this.te).discharging) {
                this.renderAirProgress -= 0.001f * Math.min(25.0f, ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
                if (this.renderAirProgress < 0.0f) {
                    this.renderAirProgress = 1.0f;
                }
            }
        }
        this.upgradeOnlyButton.m_93666_(((ChargingStationBlockEntity)this.te).upgradeOnly ? UPGRADE_ONLY_ON : UPGRADE_ONLY_OFF);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return new PointXY(this.f_97735_ + this.f_97726_ * 3 / 4 + 10, this.f_97736_ + this.f_97727_ / 4 + 10);
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((ChargingStationBlockEntity)this.te).charging || ((ChargingStationBlockEntity)this.te).discharging) {
            String key = ((ChargingStationBlockEntity)this.te).charging ? "pneumaticcraft.gui.tooltip.charging" : "pneumaticcraft.gui.tooltip.discharging";
            String amount = PneumaticCraftUtils.roundNumberTo(10.0f * ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades(), 1);
            pressureStatText.add((Component)PneumaticCraftUtils.xlate(key, amount).m_130940_(ChatFormatting.BLACK));
        } else {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.charging", 0).m_130940_(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        ItemStack chargeStack = ((ChargingStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0);
        if (!chargeStack.m_41619_() && !chargeStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent()) {
            textList.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Non-pneumatic item in the charge slot!?")));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        ItemStack chargeStack = ((ChargingStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0);
        if (chargeStack.m_41619_()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.no_item", new Object[0]));
        } else if (!((ChargingStationBlockEntity)this.te).upgradeOnly) {
            chargeStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
                String name = chargeStack.m_41786_().getString();
                if (h.getPressure() > ((ChargingStationBlockEntity)this.te).getPressure() + 0.01f && h.getPressure() <= 0.0f) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.item_empty", name));
                } else if (h.getPressure() < ((ChargingStationBlockEntity)this.te).getPressure() - 0.01f && h.getPressure() >= h.maxPressure()) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.item_full", name));
                } else if (!((ChargingStationBlockEntity)this.te).charging && !((ChargingStationBlockEntity)this.te).discharging) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.pressure_equal", name));
                }
            });
        }
    }

    private void renderAir(PoseStack matrixStack, float partialTicks) {
        RenderSystem.m_69472_();
        RenderSystem.m_69832_((float)2.0f);
        for (int i = 0; i < 10; ++i) {
            this.renderAirParticle(matrixStack, this.renderAirProgress % 0.1f + (float)i / 10.0f);
        }
        RenderSystem.m_69493_();
    }

    private void renderAirParticle(PoseStack matrixStack, float particleProgress) {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        float x = (float)xStart + 117.0f;
        float y = (float)yStart + 56.5f;
        if (particleProgress < 0.5f) {
            y += particleProgress * 56.0f;
        } else if (particleProgress < 0.7f) {
            y += 28.0f;
            x -= (particleProgress - 0.5f) * 90.0f;
        } else {
            y += 28.0f;
            x -= 18.0f;
            y -= (particleProgress - 0.7f) * 70.0f;
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        bufferbuilder.m_85982_(posMat, x - 1.0f, y + 1.0f, 0.0f).m_85950_(0.7f, 0.8f, 0.9f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(posMat, x + 1.0f, y + 1.0f, 0.0f).m_85950_(0.6f, 0.7f, 0.7f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(posMat, x + 1.0f, y - 1.0f, 0.0f).m_85950_(0.7f, 0.8f, 0.9f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(posMat, x - 1.0f, y - 1.0f, 0.0f).m_85950_(0.8f, 0.9f, 0.9f, 1.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

