/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock2.validated;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock2.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.multiblock2.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock2.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.validated.IAssemblyStateTileModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import org.jetbrains.annotations.Contract;

@NonnullDefault
public interface IValidatedMultiblockTile<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IMultiblockTile<TileType, BlockType, ControllerType> {
    default public Module<TileType, BlockType, ControllerType> validatedModule() {
        return this.module(IValidatedMultiblockTile.class, Module.class);
    }

    public static class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends TileModule<TileType> {
        private final boolean ASSEMBLY_STATE;
        private final ObjectArrayList<IAssemblyStateTileModule> assemblyStateTileModules;

        @OnModLoad
        private static void onModLoad() {
            ModuleRegistry.registerTileModule(IValidatedMultiblockTile.class, Module::new);
        }

        public Module(IModularTile iface) {
            super(iface);
            this.ASSEMBLY_STATE = ((BlockEntity)this.iface).m_58900_().m_61138_((Property)IAssemblyStateBlock.ASSEMBLED);
            this.assemblyStateTileModules = new ObjectArrayList();
        }

        @Override
        public void postModuleConstruction() {
            for (TileModule<?> module : ((IModularTile)((BlockEntity)this.iface)).modules()) {
                if (!(module instanceof IAssemblyStateTileModule)) continue;
                IAssemblyStateTileModule assemblyStateTileModule = (IAssemblyStateTileModule)((Object)module);
                this.assemblyStateTileModules.add((Object)assemblyStateTileModule);
            }
        }

        @Contract(pure=true)
        public BlockState assembledBlockState(BlockState state) {
            if (this.ASSEMBLY_STATE) {
                state = (BlockState)state.m_61124_((Property)IAssemblyStateBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true));
            }
            for (IAssemblyStateTileModule module : this.assemblyStateTileModules) {
                state = module.assembledBlockState(state);
            }
            return state;
        }

        @Contract(pure=true)
        public BlockState disassembledBlockState(BlockState state) {
            if (this.ASSEMBLY_STATE) {
                state = (BlockState)state.m_61124_((Property)IAssemblyStateBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false));
            }
            for (IAssemblyStateTileModule module : this.assemblyStateTileModules) {
                state = module.disassembledBlockState(state);
            }
            return state;
        }
    }
}

